/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.repackaged.com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.repackaged.com.networknt.schema.BaseJsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchema;
import com.fizzgate.repackaged.com.networknt.schema.JsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.ValidationContext;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.I18nUtils;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MultipleOfValidator.class);
    private double divisor = 0.0;

    public MultipleOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MULTIPLE_OF, validationContext);
        if (schemaNode.isNumber()) {
            this.divisor = schemaNode.doubleValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (node.isNumber()) {
            BigDecimal accurateDivisor;
            BigDecimal accurateDividend;
            double nodeValue = node.doubleValue();
            if (this.divisor != 0.0 && (accurateDividend = new BigDecimal(String.valueOf(nodeValue))).divideAndRemainder(accurateDivisor = new BigDecimal(String.valueOf(this.divisor)))[1].abs().compareTo(BigDecimal.ZERO) > 0) {
                String title = I18nUtils.getTitle(super.getParentSchema().getSchemaNode(), at);
                return Collections.singleton(this.buildValidationMessage(at, "" + this.divisor, title));
            }
        }
        return Collections.emptySet();
    }
}

