/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.repackaged.com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.repackaged.com.networknt.schema.BaseJsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchema;
import com.fizzgate.repackaged.com.networknt.schema.JsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.RefValidator;
import com.fizzgate.repackaged.com.networknt.schema.RequiredValidator;
import com.fizzgate.repackaged.com.networknt.schema.ValidationContext;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorState;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.PropertiesSupportUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private List<ShortcutValidator> schemas = new ArrayList<ShortcutValidator>();

    public OneOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ONE_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            JsonNode childNode = schemaNode.get(i);
            JsonSchema childSchema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), childNode, parentSchema).initialize();
            this.schemas.add(new ShortcutValidator(childNode, parentSchema, validationContext, childSchema));
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        ValidatorState state = new ValidatorState();
        state.setComplexValidator(true);
        validatorState.set(state);
        int numberOfValidSchema = 0;
        Set<Object> errors = new LinkedHashSet<ValidationMessage>();
        for (ShortcutValidator validator : this.schemas) {
            if (!validator.allConstantsMatch(node)) continue;
            JsonSchema schema = validator.schema;
            Set<ValidationMessage> schemaErrors = schema.validate(node, rootNode, at);
            if (schemaErrors.isEmpty()) {
                if (!state.hasMatchedNode()) continue;
                ++numberOfValidSchema;
                errors = new LinkedHashSet();
                continue;
            }
            errors.addAll(schemaErrors);
        }
        if (numberOfValidSchema == 0) {
            Iterator it = errors.iterator();
            while (it.hasNext()) {
                ValidationMessage msg = (ValidationMessage)it.next();
                if (!ValidatorTypeCode.ADDITIONAL_PROPERTIES.getValue().equals(msg.getType())) continue;
                it.remove();
            }
            if (errors.isEmpty()) {
                errors.add(this.buildValidationMessage(at, ""));
            }
        } else {
            errors.clear();
        }
        if (numberOfValidSchema > 1) {
            errors = Collections.singleton(this.buildValidationMessage(at, ""));
        }
        validatorState.remove();
        return Collections.unmodifiableSet(errors);
    }

    private static class ShortcutValidator {
        private final JsonSchema schema;
        private final Map<String, String> constants;

        ShortcutValidator(JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, JsonSchema schema) {
            JsonNode refNode = schemaNode.get(ValidatorTypeCode.REF.getValue());
            JsonSchema resolvedRefSchema = refNode != null && refNode.isTextual() ? RefValidator.getRefSchema(parentSchema, validationContext, refNode.textValue()).getSchema() : null;
            this.constants = this.extractConstants(schemaNode, resolvedRefSchema);
            this.schema = schema;
        }

        private Map<String, String> extractConstants(JsonNode schemaNode, JsonSchema resolvedRefSchema) {
            Map<String, String> refMap = resolvedRefSchema != null ? this.extractConstants(resolvedRefSchema.getSchemaNode()) : Collections.emptyMap();
            Map<String, String> schemaMap = this.extractConstants(schemaNode);
            if (refMap.isEmpty()) {
                return schemaMap;
            }
            if (schemaMap.isEmpty()) {
                return refMap;
            }
            HashMap<String, String> joined = new HashMap<String, String>();
            joined.putAll(schemaMap);
            joined.putAll(refMap);
            return joined;
        }

        private Map<String, String> extractConstants(JsonNode schemaNode) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (!schemaNode.isObject()) {
                return result;
            }
            JsonNode propertiesNode = schemaNode.get("properties");
            if (propertiesNode == null || !propertiesNode.isObject()) {
                return result;
            }
            Iterator fit = propertiesNode.fieldNames();
            while (fit.hasNext()) {
                String fieldName = (String)fit.next();
                JsonNode jsonNode = propertiesNode.get(fieldName);
                String constantFieldValue = this.getConstantFieldValue(jsonNode);
                if (constantFieldValue == null || constantFieldValue.isEmpty()) continue;
                result.put(fieldName, constantFieldValue);
            }
            return result;
        }

        private String getConstantFieldValue(JsonNode jsonNode) {
            if (jsonNode == null || !jsonNode.isObject() || !jsonNode.has("enum")) {
                return null;
            }
            JsonNode enumNode = jsonNode.get("enum");
            if (enumNode == null || !enumNode.isArray()) {
                return null;
            }
            if (enumNode.size() != 1) {
                return null;
            }
            JsonNode valueNode = enumNode.get(0);
            if (valueNode == null || !valueNode.isTextual()) {
                return null;
            }
            return valueNode.textValue();
        }

        public boolean allConstantsMatch(JsonNode node) {
            for (Map.Entry<String, String> e : this.constants.entrySet()) {
                boolean match;
                JsonNode valueNode = node.get(e.getKey());
                if (valueNode == null && PropertiesSupportUtils.supportPropertyUpperCase()) {
                    valueNode = node.get(e.getKey().toUpperCase());
                }
                if (valueNode == null || !valueNode.isTextual() || (match = e.getValue().equals(valueNode.textValue()))) continue;
                return false;
            }
            return true;
        }
    }
}

