/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.repackaged.com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.repackaged.com.networknt.schema.BaseJsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchema;
import com.fizzgate.repackaged.com.networknt.schema.JsonType;
import com.fizzgate.repackaged.com.networknt.schema.JsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.TypeFactory;
import com.fizzgate.repackaged.com.networknt.schema.ValidationContext;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.I18nUtils;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Regex;
import org.joni.Syntax;
import org.joni.exception.SyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(PatternValidator.class);
    private String pattern = "";
    private Pattern compiledPattern;
    private Regex compiledRegex;

    public PatternValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.PATTERN, validationContext);
        if (schemaNode != null && schemaNode.isTextual()) {
            this.pattern = schemaNode.textValue();
            try {
                this.compileRegexPattern(this.pattern, validationContext.getConfig() != null && validationContext.getConfig().isEcma262Validator());
            }
            catch (PatternSyntaxException pse) {
                logger.error("Failed to compile pattern : Invalid syntax [" + this.pattern + "]", (Throwable)pse);
                throw pse;
            }
            catch (SyntaxException se) {
                logger.error("Failed to compile pattern : Invalid syntax [" + this.pattern + "]", (Throwable)se);
                throw se;
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    private void compileRegexPattern(String regex, boolean useEcma262Validator) {
        if (useEcma262Validator) {
            byte[] regexBytes = regex.getBytes();
            this.compiledRegex = new Regex(regexBytes, 0, regexBytes.length, 0, (Encoding)UTF8Encoding.INSTANCE, Syntax.ECMAScript);
        } else {
            this.compiledPattern = Pattern.compile(this.pattern);
        }
    }

    private boolean matches(String value) {
        if (this.compiledRegex == null && this.compiledPattern == null) {
            return true;
        }
        if (this.compiledPattern == null) {
            byte[] bytes = value.getBytes();
            return this.compiledRegex.matcher(bytes).search(0, bytes.length, 0) >= 0;
        }
        return this.compiledPattern.matcher(value).find();
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        JsonType nodeType = TypeFactory.getValueNodeType(node);
        if (nodeType != JsonType.STRING) {
            return Collections.emptySet();
        }
        try {
            if (!this.matches(node.asText())) {
                String title = I18nUtils.getTitle(super.getParentSchema().getSchemaNode(), at);
                return Collections.singleton(this.buildValidationMessage(at, this.pattern, title));
            }
        }
        catch (PatternSyntaxException pse) {
            logger.error("Failed to apply pattern on " + at + ": Invalid syntax [" + this.pattern + "]", (Throwable)pse);
        }
        return Collections.emptySet();
    }
}

