/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.repackaged.com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.repackaged.com.networknt.schema.BaseJsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchema;
import com.fizzgate.repackaged.com.networknt.schema.JsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.RequiredValidator;
import com.fizzgate.repackaged.com.networknt.schema.ValidationContext;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.PropertiesSupportUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private List<String> fieldNames = new ArrayList<String>();

    public ReadOnlyValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.READ_ONLY, validationContext);
        if (schemaNode.isArray()) {
            int size = schemaNode.size();
            for (int i = 0; i < size; ++i) {
                this.fieldNames.add(schemaNode.get(i).asText());
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (String fieldName : this.fieldNames) {
            JsonNode propertyNode = node.get(fieldName);
            if (propertyNode == null && PropertiesSupportUtils.supportPropertyUpperCase()) {
                propertyNode = node.get(fieldName.toUpperCase());
            }
            String datapath = "";
            datapath = at.equals("$") ? datapath + "#original." + fieldName : datapath + "#original." + at.substring(2) + "." + fieldName;
            JsonNode originalNode = this.getNode(datapath, rootNode);
            boolean theSame = propertyNode != null && originalNode != null && propertyNode.equals((Object)originalNode);
            if (theSame) continue;
            errors.add(this.buildValidationMessage(at, new String[0]));
        }
        return Collections.unmodifiableSet(errors);
    }

    private JsonNode getNode(String datapath, JsonNode data) {
        String path = datapath;
        if (path.startsWith("$.")) {
            path = path.substring(2);
        }
        String[] parts = path.split("\\.");
        JsonNode result = null;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].contains("[")) {
                int idx1 = parts[i].indexOf("[");
                int idx2 = parts[i].indexOf("]");
                String key = parts[i].substring(0, idx1).trim();
                int idx = Integer.parseInt(parts[i].substring(idx1 + 1, idx2).trim());
                result = data.get(key).get(idx);
            } else {
                result = data.get(parts[i]);
            }
            if (result == null) break;
            data = result;
        }
        return result;
    }
}

