/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.repackaged.com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.repackaged.com.networknt.schema.BaseJsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.CustomErrorMessageType;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchema;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchemaException;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchemaRef;
import com.fizzgate.repackaged.com.networknt.schema.JsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.ValidationContext;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorTypeCode;
import com.fizzgate.repackaged.com.networknt.schema.uri.URIFactory;
import com.fizzgate.repackaged.com.networknt.schema.urn.URNFactory;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected JsonSchemaRef schema;
    private static final String REF_CURRENT = "#";

    public RefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        this.schema = RefValidator.getRefSchema(parentSchema, validationContext, refValue);
        if (this.schema == null) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.REF.getValue(), CustomErrorMessageType.of("internal.unresolvedRef", new MessageFormat("{0}: Reference {1} cannot be resolved")), schemaPath, refValue));
        }
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue) {
        String refValueOriginal = refValue;
        if (!refValue.startsWith(REF_CURRENT)) {
            int index = refValue.indexOf(REF_CURRENT);
            String refUri = index > 0 ? refValue.substring(0, index) : refValue;
            URI schemaUri = RefValidator.determineSchemaUri(validationContext.getURIFactory(), parentSchema, refUri);
            if (schemaUri == null) {
                if (validationContext.getURNFactory() == null) {
                    return null;
                }
                schemaUri = RefValidator.determineSchemaUrn(validationContext.getURNFactory(), refUri);
                if (schemaUri == null) {
                    return null;
                }
            }
            parentSchema = validationContext.getJsonSchemaFactory().getSchema(schemaUri, validationContext.getConfig());
            if (index < 0) {
                return new JsonSchemaRef(parentSchema.findAncestor());
            }
            refValue = refValue.substring(index);
        }
        if (refValue.equals(REF_CURRENT)) {
            return new JsonSchemaRef(parentSchema.findAncestor());
        }
        JsonNode node = parentSchema.getRefSchemaNode(refValue);
        if (node != null) {
            JsonSchemaRef ref = validationContext.getReferenceParsingInProgress(refValueOriginal);
            if (ref == null) {
                ref = new JsonSchemaRef(validationContext, refValue);
                validationContext.setReferenceParsingInProgress(refValueOriginal, ref);
                JsonSchema ret = new JsonSchema(validationContext, refValue, parentSchema.getCurrentUri(), node, parentSchema).initialize();
                ref.set(ret);
            }
            return ref;
        }
        return null;
    }

    private static URI determineSchemaUri(URIFactory uriFactory, JsonSchema parentSchema, String refUri) {
        URI schemaUri;
        URI currentUri = parentSchema.getCurrentUri();
        try {
            schemaUri = currentUri == null ? uriFactory.create(refUri) : uriFactory.create(currentUri, refUri);
        }
        catch (IllegalArgumentException e) {
            schemaUri = null;
        }
        return schemaUri;
    }

    private static URI determineSchemaUrn(URNFactory urnFactory, String refUri) {
        URI schemaUrn;
        try {
            schemaUrn = urnFactory.create(refUri);
        }
        catch (IllegalArgumentException e) {
            schemaUrn = null;
        }
        return schemaUrn;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.schema != null) {
            return this.schema.validate(node, rootNode, at);
        }
        return Collections.emptySet();
    }
}

