/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.repackaged.com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.repackaged.com.networknt.schema.BaseJsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchema;
import com.fizzgate.repackaged.com.networknt.schema.JsonType;
import com.fizzgate.repackaged.com.networknt.schema.JsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.TypeFactory;
import com.fizzgate.repackaged.com.networknt.schema.UnionTypeValidator;
import com.fizzgate.repackaged.com.networknt.schema.ValidationContext;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.I18nUtils;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final String TYPE = "type";
    private static final String ENUM = "enum";
    private static final String REF = "$ref";
    private static final Logger logger = LoggerFactory.getLogger(TypeValidator.class);
    private JsonType schemaType;
    private JsonSchema parentSchema;
    private UnionTypeValidator unionTypeValidator;
    private static final char CHAR_0 = '0';
    private static final char CHAR_1 = '1';
    private static final char CHAR_9 = '9';
    private static final char MINUS = '-';
    private static final char PLUS = '+';
    private static final char DOT = '.';
    private static final char CHAR_E = 'E';
    private static final char CHAR_e = 'e';

    public TypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.TYPE, validationContext);
        this.schemaType = TypeFactory.getSchemaNodeType(schemaNode);
        this.parentSchema = parentSchema;
        if (this.schemaType == JsonType.UNION) {
            this.unionTypeValidator = new UnionTypeValidator(schemaPath, schemaNode, parentSchema, validationContext);
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    public JsonType getSchemaType() {
        return this.schemaType;
    }

    public boolean equalsToSchemaType(JsonNode node) {
        JsonType nodeType = TypeFactory.getValueNodeType(node);
        if (nodeType != this.schemaType) {
            JsonNode nullable;
            if (this.schemaType == JsonType.ANY) {
                return true;
            }
            if (this.schemaType == JsonType.NUMBER && nodeType == JsonType.INTEGER) {
                return true;
            }
            if (nodeType == JsonType.NULL && (nullable = this.getParentSchema().getSchemaNode().get("nullable")) != null && nullable.asBoolean()) {
                return true;
            }
            if (TypeValidator.isEnumObjectSchema(this.parentSchema)) {
                return true;
            }
            if (this.config.isTypeLoose()) {
                if (this.schemaType == JsonType.ARRAY) {
                    return true;
                }
                if (nodeType == JsonType.STRING && (this.schemaType == JsonType.INTEGER ? TypeValidator.isInteger(node.textValue()) : (this.schemaType == JsonType.BOOLEAN ? TypeValidator.isBoolean(node.textValue()) : this.schemaType == JsonType.NUMBER && TypeValidator.isNumeric(node.textValue())))) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.schemaType == JsonType.UNION) {
            return this.unionTypeValidator.validate(node, rootNode, at);
        }
        if (!this.equalsToSchemaType(node)) {
            JsonType nodeType = TypeFactory.getValueNodeType(node);
            String title = I18nUtils.getTitle(super.getParentSchema().getSchemaNode(), at);
            return Collections.singleton(this.buildValidationMessage(at, nodeType.toString(), this.schemaType.toString(), title));
        }
        return Collections.emptySet();
    }

    public static boolean isInteger(String str) {
        if (str == null || str.equals("")) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-' || str.charAt(0) == '+') {
            if (str.length() == 1) {
                return false;
            }
            i = 1;
        }
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBoolean(String s) {
        return "true".equals(s) || "false".equals(s);
    }

    public static boolean isNumeric(String str) {
        char c;
        if (str == null || str.equals("")) {
            return false;
        }
        int i = 0;
        int len = str.length();
        if (str.charAt(i) == '-' || str.charAt(i) == '+') {
            if (str.length() == 1) {
                return false;
            }
            i = 1;
        }
        if ((c = str.charAt(i++)) == '0') {
            if (i < len && (c = str.charAt(i++)) != '.' && c != 'E' && c != 'e') {
                return false;
            }
        } else if ('1' <= c && c <= '9') {
            while (i < len && '0' <= c && c <= '9') {
                c = str.charAt(i++);
            }
        } else {
            return false;
        }
        if (c == '.') {
            if (i >= len) {
                return false;
            }
            c = str.charAt(i++);
            while (i < len && '0' <= c && c <= '9') {
                c = str.charAt(i++);
            }
        }
        if (c == 'E' || c == 'e') {
            if (i >= len) {
                return false;
            }
            if ((c = str.charAt(i++)) == '+' || c == '-') {
                if (i >= len) {
                    return false;
                }
                c = str.charAt(i++);
            }
            while (i < len && '0' <= c && c <= '9') {
                c = str.charAt(i++);
            }
        }
        return i >= len && '0' <= c && c <= '9';
    }

    public static boolean isNumber(JsonNode node, boolean isTypeLoose) {
        if (node.isNumber()) {
            return true;
        }
        if (isTypeLoose && TypeFactory.getValueNodeType(node) == JsonType.STRING) {
            return TypeValidator.isNumeric(node.textValue());
        }
        return false;
    }

    private static boolean isEnumObjectSchema(JsonSchema jsonSchema) {
        JsonNode typeNode = null;
        JsonNode enumNode = null;
        JsonNode refNode = null;
        if (jsonSchema != null) {
            if (jsonSchema.getSchemaNode() != null) {
                typeNode = jsonSchema.getSchemaNode().get(TYPE);
                enumNode = jsonSchema.getSchemaNode().get(ENUM);
            }
            if (jsonSchema.getParentSchema() != null && jsonSchema.getParentSchema().getSchemaNode() != null) {
                refNode = jsonSchema.getParentSchema().getSchemaNode().get(REF);
            }
        }
        if (typeNode != null && enumNode != null && refNode != null) {
            return TypeFactory.getSchemaNodeType(typeNode) == JsonType.OBJECT && enumNode.isArray();
        }
        return false;
    }
}

