/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.repackaged.com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.repackaged.com.networknt.schema.BaseJsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchema;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchemaException;
import com.fizzgate.repackaged.com.networknt.schema.JsonType;
import com.fizzgate.repackaged.com.networknt.schema.JsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.TypeFactory;
import com.fizzgate.repackaged.com.networknt.schema.TypeValidator;
import com.fizzgate.repackaged.com.networknt.schema.ValidationContext;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionTypeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnionTypeValidator.class);
    private List<JsonValidator> schemas = new ArrayList<JsonValidator>();
    private String error;

    public UnionTypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNION_TYPE, validationContext);
        StringBuilder errorBuilder = new StringBuilder();
        String sep = "";
        errorBuilder.append('[');
        if (!schemaNode.isArray()) {
            throw new JsonSchemaException("Expected array for type property on Union Type Definition.");
        }
        int i = 0;
        for (JsonNode n : schemaNode) {
            JsonType t = TypeFactory.getSchemaNodeType(n);
            errorBuilder.append(sep).append((Object)t);
            sep = ", ";
            if (n.isObject()) {
                this.schemas.add(new JsonSchema(validationContext, ValidatorTypeCode.TYPE.getValue(), parentSchema.getCurrentUri(), n, parentSchema).initialize());
            } else {
                this.schemas.add(new TypeValidator(schemaPath + "/" + i, n, parentSchema, validationContext));
            }
            ++i;
        }
        errorBuilder.append(']');
        this.error = errorBuilder.toString();
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        JsonType nodeType = TypeFactory.getValueNodeType(node);
        boolean valid = false;
        for (JsonValidator schema : this.schemas) {
            Set<ValidationMessage> errors = schema.validate(node, rootNode, at);
            if (errors != null && !errors.isEmpty()) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return Collections.singleton(this.buildValidationMessage(at, nodeType.toString(), this.error));
        }
        return Collections.emptySet();
    }
}

