/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.repackaged.com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzgate.repackaged.com.networknt.schema.BaseJsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchema;
import com.fizzgate.repackaged.com.networknt.schema.JsonValidator;
import com.fizzgate.repackaged.com.networknt.schema.ValidationContext;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorTypeCode;
import com.fizzgate.schema.util.I18nUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueItemsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UniqueItemsValidator.class);
    private boolean unique = false;

    public UniqueItemsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNIQUE_ITEMS, validationContext);
        if (schemaNode.isBoolean()) {
            this.unique = schemaNode.booleanValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.unique) {
            HashSet<JsonNode> set = new HashSet<JsonNode>();
            for (JsonNode n : node) {
                if (set.add(n)) continue;
                String title = I18nUtils.getTitle(super.getParentSchema().getSchemaNode(), at);
                return Collections.singleton(this.buildValidationMessage(at, title));
            }
        }
        return Collections.emptySet();
    }
}

