/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.spring.http.server.reactive.ext;

import com.fizzgate.util.NettyDataBufferUtils;
import io.netty.handler.codec.http.cookie.Cookie;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.netty.http.server.HttpServerRequest;

public class FizzServerHttpRequestDecorator
extends ServerHttpRequestDecorator {
    private static final Pattern QUERY_PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");
    private AbstractServerHttpRequest delegate;
    private HttpServerRequest nativeRequest;
    @Nullable
    private MultiValueMap<String, String> queryParams;
    private HttpHeaders headers;
    @Nullable
    private MultiValueMap<String, HttpCookie> cookies;
    private Flux<DataBuffer> body = Flux.empty();
    private byte[] bodyBytes;

    public FizzServerHttpRequestDecorator(ServerHttpRequest delegate) {
        super(delegate);
        this.delegate = (AbstractServerHttpRequest)delegate;
        try {
            this.nativeRequest = (HttpServerRequest)this.delegate.getNativeRequest();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public MultiValueMap<String, String> getQueryParams() {
        if (this.queryParams == null) {
            this.queryParams = this.initQueryParams();
        }
        return this.queryParams;
    }

    private MultiValueMap<String, String> initQueryParams() {
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        String query = this.getURI().getRawQuery();
        if (query != null) {
            Matcher matcher = QUERY_PATTERN.matcher(query);
            while (matcher.find()) {
                String name = this.decodeQueryParam(matcher.group(1));
                String eq = matcher.group(2);
                String value = matcher.group(3);
                value = value != null ? this.decodeQueryParam(value) : (StringUtils.hasLength((String)eq) ? "" : null);
                queryParams.add((Object)name, (Object)value);
            }
        }
        return queryParams;
    }

    private String decodeQueryParam(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLDecoder.decode(value);
        }
    }

    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = HttpHeaders.writableHttpHeaders((HttpHeaders)this.delegate.getHeaders());
        }
        return this.headers;
    }

    public MultiValueMap<String, HttpCookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = this.initCookies();
        }
        return this.cookies;
    }

    private MultiValueMap<String, HttpCookie> initCookies() {
        if (this.nativeRequest == null) {
            return null;
        }
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (CharSequence name : this.nativeRequest.cookies().keySet()) {
            for (Cookie cookie : (Set)this.nativeRequest.cookies().get(name)) {
                HttpCookie httpCookie = new HttpCookie(name.toString(), cookie.value());
                cookies.add((Object)name.toString(), (Object)httpCookie);
            }
        }
        return cookies;
    }

    public void setEmptyBody() {
        this.body = Flux.empty();
        this.bodyBytes = null;
    }

    public void setBody(DataBuffer body) {
        if (body instanceof PooledDataBuffer) {
            byte[] bytes = NettyDataBufferUtils.copyBytes(body);
            this.setBody(bytes);
        } else {
            this.body = Flux.just((Object)body);
            ByteBuffer byteBuffer = body.asByteBuffer();
            if (byteBuffer.hasArray()) {
                this.bodyBytes = byteBuffer.array();
            }
        }
    }

    public void setBody(String body) {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        this.setBody(bytes);
    }

    public void setBody(byte[] body) {
        this.bodyBytes = body;
        NettyDataBuffer from = NettyDataBufferUtils.from(this.bodyBytes);
        this.body = Flux.just((Object)from);
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }
}

