/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.spring.http.server.reactive.ext;

import com.fizzgate.util.NettyDataBufferUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import reactor.core.publisher.Mono;

public abstract class FizzServerHttpResponseDecorator
extends ServerHttpResponseDecorator {
    public FizzServerHttpResponseDecorator(ServerHttpResponse delegate) {
        super(delegate);
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> bodyPublisher) {
        return NettyDataBufferUtils.join(bodyPublisher).defaultIfEmpty((Object)NettyDataBufferUtils.EMPTY_DATA_BUFFER).flatMap(body -> {
            DataBuffer b = null;
            if (body != NettyDataBufferUtils.EMPTY_DATA_BUFFER) {
                if (body instanceof PooledDataBuffer) {
                    try {
                        b = NettyDataBufferUtils.copy2heap(body);
                    }
                    finally {
                        NettyDataBufferUtils.release((DataBuffer)body);
                    }
                } else {
                    b = body;
                }
            }
            Publisher<? extends DataBuffer> r = this.writeWith(b);
            return super.writeWith(r);
        });
    }

    public abstract Publisher<? extends DataBuffer> writeWith(DataBuffer var1);
}

