/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.spring.web.server.ext;

import com.fizzgate.spring.http.server.reactive.ext.FizzServerHttpRequestDecorator;
import com.fizzgate.util.NettyDataBufferUtils;
import com.fizzgate.util.ThreadContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import reactor.core.publisher.Mono;

public class FizzServerWebExchangeDecorator
extends ServerWebExchangeDecorator {
    public static final MultiValueMap<String, String> EMPTY_FORM_DATA = CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)new LinkedMultiValueMap(0));
    public static final Mono<MultiValueMap<String, String>> EMPTY_FORM_DATA_MONO = Mono.just(EMPTY_FORM_DATA).cache();

    public FizzServerWebExchangeDecorator(ServerWebExchange delegate) {
        super(delegate);
    }

    private Charset getMediaTypeCharset(@Nullable MediaType mediaType) {
        if (mediaType != null && mediaType.getCharset() != null) {
            return mediaType.getCharset();
        }
        return StandardCharsets.UTF_8;
    }

    private MultiValueMap<String, String> parseFormData(Charset charset, String source) {
        String[] pairs = StringUtils.tokenizeToStringArray((String)source, (String)"&");
        LinkedMultiValueMap result = new LinkedMultiValueMap(pairs.length);
        try {
            for (String pair : pairs) {
                int idx = pair.indexOf(61);
                if (idx == -1) {
                    result.add((Object)URLDecoder.decode(pair, charset.name()), null);
                    continue;
                }
                String name = URLDecoder.decode(pair.substring(0, idx), charset.name());
                String value = URLDecoder.decode(pair.substring(idx + 1), charset.name());
                result.add((Object)name, (Object)value);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        return result;
    }

    public Mono<MultiValueMap<String, String>> getFormData() {
        ServerHttpRequest req = this.getDelegate().getRequest();
        MediaType ct = req.getHeaders().getContentType();
        if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(ct)) {
            Charset charset = this.getMediaTypeCharset(ct);
            return req.getBody().defaultIfEmpty((Object)NettyDataBufferUtils.EMPTY_DATA_BUFFER).single().map(body -> {
                if (body == NettyDataBufferUtils.EMPTY_DATA_BUFFER) {
                    return EMPTY_FORM_DATA;
                }
                CharBuffer charBuffer = charset.decode(body.asByteBuffer());
                return this.parseFormData(charset, charBuffer.toString());
            });
        }
        return EMPTY_FORM_DATA_MONO;
    }

    public void setFormData(MultiValueMap<String, String> dataMap) {
        FizzServerHttpRequestDecorator req = (FizzServerHttpRequestDecorator)this.getDelegate().getRequest();
        req.getHeaders().setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (CollectionUtils.isEmpty(dataMap)) {
            req.setEmptyBody();
            return;
        }
        StringBuilder b = ThreadContext.getStringBuilder();
        Set fieldValuesEntries = dataMap.entrySet();
        int fs = fieldValuesEntries.size();
        int cnt = 0;
        try {
            for (Map.Entry fieldValuesEntry : fieldValuesEntries) {
                String field = (String)fieldValuesEntry.getKey();
                List values = (List)fieldValuesEntry.getValue();
                if (values.isEmpty()) {
                    b.append(URLEncoder.encode(field, "UTF-8"));
                } else {
                    int vs = values.size();
                    int i = 0;
                    while (i < vs) {
                        String v = (String)values.get(i);
                        b.append(URLEncoder.encode(field, "UTF-8"));
                        if (v != null) {
                            b.append('=');
                            if (!"".equals(v)) {
                                b.append(URLEncoder.encode(v, "UTF-8"));
                            }
                        }
                        if (++i == vs) continue;
                        b.append('&');
                    }
                }
                if (++cnt == fs) continue;
                b.append('&');
            }
            req.setBody(b.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

