/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class DateTimeUtils {
    private static Map<String, DateTimeFormatter> dateTimeFormatterMap = new HashMap<String, DateTimeFormatter>();
    private static ZoneId defaultZone = ZoneId.systemDefault();
    @Deprecated
    private static final String zeroTimeSuffix = " 00:00:00.000";

    private DateTimeUtils() {
    }

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatter f = dateTimeFormatterMap.get(pattern);
        if (f == null) {
            f = DateTimeFormatter.ofPattern(pattern);
            dateTimeFormatterMap.put(pattern, f);
        }
        return f;
    }

    public static long toMillis(LocalDate ld) {
        LocalDateTime ldt = ld.atStartOfDay();
        return DateTimeUtils.toMillis(ldt);
    }

    public static long toMillis(LocalDateTime ldt) {
        return ldt.atZone(defaultZone).toInstant().toEpochMilli();
    }

    @Deprecated
    public static long toMillis(String dateTime, String ... pattern) {
        if (dateTime.length() == 10) {
            dateTime = dateTime + zeroTimeSuffix;
        }
        String p = "yyyy-MM-dd HH:mm:ss.SSS";
        if (pattern.length != 0) {
            p = pattern[0];
        }
        DateTimeFormatter f = DateTimeUtils.getDateTimeFormatter(p);
        LocalDateTime ldt = LocalDateTime.parse(dateTime, f);
        return DateTimeUtils.toMillis(ldt);
    }

    public static long toMillis(String dateTime, String pattern) {
        DateTimeFormatter f = DateTimeUtils.getDateTimeFormatter(pattern);
        LocalDateTime ldt = LocalDateTime.parse(dateTime, f);
        return DateTimeUtils.toMillis(ldt);
    }

    public static LocalDate transform(Date date) {
        return date.toInstant().atZone(defaultZone).toLocalDate();
    }

    public static LocalDateTime transform(long l) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(l), defaultZone);
    }

    public static LocalDateTime localDateTimeFrom(Date date) {
        return date.toInstant().atZone(defaultZone).toLocalDateTime();
    }

    public static Date from(Instant i) {
        return new Date(i.toEpochMilli());
    }

    public static Date from(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(defaultZone).toInstant());
    }

    public static Date from(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(defaultZone).toInstant());
    }

    @Deprecated
    public static String convert(long mills, String ... pattern) {
        String p = "yyyy-MM-dd";
        if (pattern.length != 0) {
            p = pattern[0];
        }
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(mills), defaultZone);
        DateTimeFormatter f = DateTimeUtils.getDateTimeFormatter(p);
        return ldt.format(f);
    }

    public static String convert(long mills, String pattern) {
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(mills), defaultZone);
        DateTimeFormatter f = DateTimeUtils.getDateTimeFormatter(pattern);
        return ldt.format(f);
    }

    @Deprecated
    public static String convert(LocalDate date, String ... pattern) {
        String p = "yyyy-MM-dd";
        if (pattern.length != 0) {
            p = pattern[0];
        }
        DateTimeFormatter f = DateTimeUtils.getDateTimeFormatter(p);
        return date.format(f);
    }

    public static String convert(LocalDate date, String pattern) {
        DateTimeFormatter f = DateTimeUtils.getDateTimeFormatter(pattern);
        return date.format(f);
    }

    @Deprecated
    public static String convert(LocalDateTime localDateTime, String ... pattern) {
        String p = "yyyy-MM-dd HH:mm:ss.SSS";
        if (pattern.length != 0) {
            p = pattern[0];
        }
        DateTimeFormatter f = DateTimeUtils.getDateTimeFormatter(p);
        return localDateTime.format(f);
    }

    public static String convert(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter f = DateTimeUtils.getDateTimeFormatter(pattern);
        return localDateTime.format(f);
    }

    public static List<String> datesBetween(String start, String end) {
        LocalDate ed;
        LocalDate sd = LocalDate.parse(start);
        long dist = ChronoUnit.DAYS.between(sd, ed = LocalDate.parse(end));
        if (dist == 0L) {
            return Collections.emptyList();
        }
        if (dist < 0L) {
            LocalDate d2 = ed;
            ed = sd;
            sd = d2;
            dist = Math.abs(dist);
        }
        long max = dist + 1L;
        return Stream.iterate(sd, d -> d.plusDays(1L)).limit(max).map(LocalDate::toString).collect(Collectors.toList());
    }

    public static List<LocalDate> datesBetween(LocalDate sd, LocalDate ed) {
        long numOfDaysBetween = ChronoUnit.DAYS.between(sd, ed);
        return IntStream.iterate(0, i -> i + 1).limit(numOfDaysBetween).mapToObj(sd::plusDays).collect(Collectors.toList());
    }

    public static LocalDate beforeNow(long offsetDays) {
        return LocalDate.now().minusDays(offsetDays);
    }

    public static LocalDateTime beforeNowNoTime(long offsetDays) {
        return LocalDate.now().minusDays(offsetDays).atStartOfDay();
    }

    @Deprecated
    public static LocalDateTime time2zero(LocalDateTime ldt) {
        return ldt.withHour(0).withMinute(0).withSecond(0).with(ChronoField.MILLI_OF_SECOND, 0L);
    }

    public static long get10sTimeWinStart(int n) {
        LocalDateTime now = LocalDateTime.now().with(ChronoField.MILLI_OF_SECOND, 0L);
        int sec = now.getSecond();
        long interval = sec > 49 ? (long)(sec - 50) : (sec > 39 ? (long)(sec - 40) : (sec > 29 ? (long)(sec - 30) : (sec > 19 ? (long)(sec - 20) : (sec > 9 ? (long)(sec - 10) : (long)sec))));
        long millis = DateTimeUtils.toMillis(now);
        return millis - interval * 1000L - (long)(n - 1) * 10L * 1000L;
    }
}

