/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;

public abstract class JacksonUtils {
    private static ObjectMapper m;

    private JacksonUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return m;
    }

    public static TypeFactory getTypeFactory() {
        return m.getTypeFactory();
    }

    public static <T> T readValue(String json, Class<T> clz) {
        try {
            return (T)m.readValue(json, clz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValue(String json, TypeReference<T> typeRef) {
        try {
            return (T)m.readValue(json, typeRef);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValue(String json, JavaType javaType) {
        try {
            return (T)m.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValue(byte[] bytes, Class<T> clz) {
        try {
            return (T)m.readValue(bytes, clz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValue(byte[] bytes, TypeReference<T> typeRef) {
        try {
            return (T)m.readValue(bytes, typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValue(byte[] bytes, JavaType javaType) {
        try {
            return (T)m.readValue(bytes, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String writeValueAsString(Object value) {
        try {
            return m.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] writeValueAsBytes(Object value) {
        try {
            return m.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        JsonFactory f = new JsonFactory();
        f.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        f.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        m = new ObjectMapper(f);
        m.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        m.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        m.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, true);
        m.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, true);
        m.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
        m.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, true);
        m.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        m.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        m.registerModule((Module)javaTimeModule);
    }
}

