/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchema;
import com.fizzgate.repackaged.com.networknt.schema.JsonSchemaFactory;
import com.fizzgate.repackaged.com.networknt.schema.SchemaValidatorsConfig;
import com.fizzgate.repackaged.com.networknt.schema.SpecVersion;
import com.fizzgate.repackaged.com.networknt.schema.ValidationMessage;
import com.fizzgate.repackaged.com.networknt.schema.ValidatorTypeCode;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class JsonSchemaUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonSchemaUtils.class);
    private static final JsonSchemaFactory JSON_SCHEMA_FACTORY;
    private static final SchemaValidatorsConfig CONFIG_WITH_TYPE_LOOSE;
    private static final SchemaValidatorsConfig CONFIG_WITHOUT_TYPE_LOOSE;
    private static final ObjectMapper OBJECT_MAPPER;

    private JsonSchemaUtils() {
    }

    public static List<String> validate(String jsonSchema, String inputJson) {
        return JsonSchemaUtils.internalValidate(jsonSchema, inputJson, Boolean.FALSE);
    }

    public static List<String> validateAllowValueStr(String jsonSchema, String inputJson) {
        return JsonSchemaUtils.internalValidate(jsonSchema, inputJson, Boolean.TRUE);
    }

    private static List<String> internalValidate(String jsonSchema, String inputJson, boolean typeLoose) {
        CheckJsonResult checkJsonResult = JsonSchemaUtils.checkJson(jsonSchema, inputJson, typeLoose);
        if (checkJsonResult.errorList != null) {
            return checkJsonResult.errorList;
        }
        Set<ValidationMessage> validationMessageSet = checkJsonResult.schema.validate(checkJsonResult.json);
        if (CollectionUtils.isEmpty(validationMessageSet)) {
            return null;
        }
        return validationMessageSet.stream().map(validationMessage -> {
            String message = validationMessage.getMessage();
            if (message != null) {
                return message;
            }
            return validationMessage.getCode();
        }).collect(Collectors.toList());
    }

    private static CheckJsonResult checkJson(String jsonSchema, String inputJson, boolean typeLoose) {
        CheckJsonResult checkJsonResult = new CheckJsonResult();
        try {
            checkJsonResult.schema = JsonSchemaUtils.getJsonSchemaFromStringContent(jsonSchema, typeLoose);
        }
        catch (Exception e) {
            checkJsonResult.errorList = new ArrayList<String>(1);
            checkJsonResult.errorList.add(String.format("JSON Schema\u683c\u5f0f\u9519\u8bef\uff0c\u63d0\u793a\u4fe1\u606f[%s]", e.getMessage()));
            return checkJsonResult;
        }
        try {
            checkJsonResult.json = JsonSchemaUtils.getJsonNodeFromStringContent(inputJson);
        }
        catch (Exception e) {
            checkJsonResult.errorList = new ArrayList<String>(1);
            checkJsonResult.errorList.add(String.format("\u5f85\u9a8c\u8bc1JSON\u683c\u5f0f\u9519\u8bef\uff0c\u63d0\u793a\u4fe1\u606f[%s]", e.getMessage()));
            return checkJsonResult;
        }
        return checkJsonResult;
    }

    private static JsonSchema getJsonSchemaFromStringContent(String schemaContent, boolean typeLoose) {
        SchemaValidatorsConfig config = typeLoose ? CONFIG_WITH_TYPE_LOOSE : CONFIG_WITHOUT_TYPE_LOOSE;
        return JSON_SCHEMA_FACTORY.getSchema(schemaContent, config);
    }

    private static JsonNode getJsonNodeFromStringContent(String content) throws Exception {
        return OBJECT_MAPPER.readTree(content);
    }

    static {
        try {
            Field messageFormatField = ValidatorTypeCode.class.getDeclaredField("messageFormat");
            messageFormatField.setAccessible(true);
            messageFormatField.set(ValidatorTypeCode.ADDITIONAL_PROPERTIES, new MessageFormat("{1}\u5728schema\u4e2d\u6ca1\u6709\u5b9a\u4e49\u5e76\u4e14schema\u4e0d\u5141\u8bb8\u6307\u5b9a\u5916\u7684\u5b57\u6bb5"));
            messageFormatField.set(ValidatorTypeCode.ALL_OF, new MessageFormat("should be valid to all the schemas {1}"));
            messageFormatField.set(ValidatorTypeCode.ANY_OF, new MessageFormat("should be valid to any of the schemas {1}"));
            messageFormatField.set(ValidatorTypeCode.CROSS_EDITS, new MessageFormat("has an error with 'cross edits'"));
            messageFormatField.set(ValidatorTypeCode.DEPENDENCIES, new MessageFormat("has an error with dependencies {1}"));
            messageFormatField.set(ValidatorTypeCode.EDITS, new MessageFormat("has an error with 'edits'"));
            messageFormatField.set(ValidatorTypeCode.ENUM, new MessageFormat("\u503c\u4e0d\u5728\u9650\u5b9a{1}\u5185"));
            messageFormatField.set(ValidatorTypeCode.FORMAT, new MessageFormat("\u4e0d\u7b26\u5408{1}\u683c\u5f0f{2}"));
            messageFormatField.set(ValidatorTypeCode.ITEMS, new MessageFormat("\u5728\u7d22\u5f15[{1}]\u5904\u4e3a\u627e\u5230\u9a8c\u8bc1\u5668"));
            messageFormatField.set(ValidatorTypeCode.MAXIMUM, new MessageFormat("\u7ed9\u5b9a\u503c\u5e94\u5f53\u5c0f\u4e8e\u7b49\u4e8e{1}"));
            messageFormatField.set(ValidatorTypeCode.MAX_ITEMS, new MessageFormat("\u6570\u7ec4\u81f3\u591a\u542b\u6709{1}\u4e2a\u5143\u7d20"));
            messageFormatField.set(ValidatorTypeCode.MAX_LENGTH, new MessageFormat("\u957f\u5ea6\u5e94\u5f53\u6700\u591a{1}"));
            messageFormatField.set(ValidatorTypeCode.MAX_PROPERTIES, new MessageFormat("\u5bf9\u8c61\u6700\u591a\u6709{1}\u4e2a\u5b57\u6bb5"));
            messageFormatField.set(ValidatorTypeCode.MINIMUM, new MessageFormat("\u7ed9\u5b9a\u503c\u5e94\u5f53\u5927\u4e8e\u7b49\u4e8e{1}"));
            messageFormatField.set(ValidatorTypeCode.MIN_ITEMS, new MessageFormat("\u6570\u7ec4\u81f3\u5c11\u542b\u6709{1}\u4e2a\u5143\u7d20"));
            messageFormatField.set(ValidatorTypeCode.MIN_LENGTH, new MessageFormat("\u957f\u5ea6\u5e94\u5f53\u6700\u5c11{1}"));
            messageFormatField.set(ValidatorTypeCode.MIN_PROPERTIES, new MessageFormat("{0}:\u5bf9\u8c61\u6700\u5c11\u6709{1}\u4e2a\u5b57\u6bb5"));
            messageFormatField.set(ValidatorTypeCode.MULTIPLE_OF, new MessageFormat("\u6570\u503c\u7c7b\u578b\u5e94\u5f53\u662f{1}"));
            messageFormatField.set(ValidatorTypeCode.NOT_ALLOWED, new MessageFormat("{1}\u4e0d\u5141\u8bb8\u51fa\u73b0\u5728\u6570\u636e\u4e2d"));
            messageFormatField.set(ValidatorTypeCode.NOT, new MessageFormat("should not be valid to the schema {1}"));
            messageFormatField.set(ValidatorTypeCode.ONE_OF, new MessageFormat("should be valid to one and only one of the schemas {1}"));
            messageFormatField.set(ValidatorTypeCode.PATTERN_PROPERTIES, new MessageFormat("has some error with 'pattern properties'"));
            messageFormatField.set(ValidatorTypeCode.PATTERN, new MessageFormat("\u5e94\u5f53\u7b26\u5408\u683c\u5f0f\"{1}\""));
            messageFormatField.set(ValidatorTypeCode.PROPERTIES, new MessageFormat("\u5bf9\u8c61\u5b57\u6bb5\u5b58\u5728\u9519\u8bef"));
            messageFormatField.set(ValidatorTypeCode.READ_ONLY, new MessageFormat("is a readonly field, it cannot be changed"));
            messageFormatField.set(ValidatorTypeCode.REF, new MessageFormat("has an error with 'refs'"));
            messageFormatField.set(ValidatorTypeCode.REQUIRED, new MessageFormat("{1}\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"));
            messageFormatField.set(ValidatorTypeCode.TYPE, new MessageFormat("\u9884\u671f\u7c7b\u578b\u662f{2},\u4f46\u5b9e\u9645\u662f{1}"));
            messageFormatField.set(ValidatorTypeCode.UNION_TYPE, new MessageFormat("\u9884\u671f\u7c7b\u578b\u662f{2},\u4f46\u5b9e\u9645\u662f{1}"));
            messageFormatField.set(ValidatorTypeCode.UNIQUE_ITEMS, new MessageFormat("\u6570\u7ec4\u5143\u7d20\u552f\u4e00\u6027\u51b2\u7a81"));
            messageFormatField.set(ValidatorTypeCode.DATETIME, new MessageFormat("{1}\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684{2}"));
            messageFormatField.set(ValidatorTypeCode.UUID, new MessageFormat("{1}\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684{2}"));
            messageFormatField.set(ValidatorTypeCode.ID, new MessageFormat("{1} is an invalid segment for URI {2}"));
            messageFormatField.set(ValidatorTypeCode.EXCLUSIVE_MAXIMUM, new MessageFormat("\u7ed9\u5b9a\u503c\u5e94\u5f53\u5c0f\u4e8e{1}"));
            messageFormatField.set(ValidatorTypeCode.EXCLUSIVE_MINIMUM, new MessageFormat("\u7ed9\u5b9a\u503c\u5e94\u5f53\u5927\u4e8e{1}"));
            messageFormatField.set(ValidatorTypeCode.FALSE, new MessageFormat("Boolean schema false is not valid"));
            messageFormatField.set(ValidatorTypeCode.CONST, new MessageFormat("\u503c\u5e94\u5f53\u662f\u4e00\u4e2a\u5e38\u91cf{1}"));
            messageFormatField.set(ValidatorTypeCode.CONTAINS, new MessageFormat("\u6ca1\u6709\u5305\u542b\u5143\u7d20\u80fd\u591f\u901a\u8fc7\u9a8c\u8bc1:{1}"));
        }
        catch (Exception e) {
            LOGGER.warn("\u66ff\u6362ValidatorTypeCode.messageFormat\u5f02\u5e38", (Throwable)e);
        }
        JSON_SCHEMA_FACTORY = JsonSchemaFactory.getInstance(SpecVersion.VersionFlag.V7);
        OBJECT_MAPPER = new ObjectMapper();
        CONFIG_WITH_TYPE_LOOSE = new SchemaValidatorsConfig();
        CONFIG_WITH_TYPE_LOOSE.setTypeLoose(Boolean.TRUE);
        CONFIG_WITHOUT_TYPE_LOOSE = new SchemaValidatorsConfig();
        CONFIG_WITHOUT_TYPE_LOOSE.setTypeLoose(Boolean.FALSE);
    }

    private static class CheckJsonResult {
        JsonSchema schema;
        JsonNode json;
        List<String> errorList;

        private CheckJsonResult() {
        }
    }
}

