/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import com.fizzgate.util.UUIDUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class MapUtil {
    private static final String KEY = "key";
    private static final String VALUE = "value";

    public static HttpHeaders toHttpHeaders(Map<String, Object> params) {
        HttpHeaders headers = new HttpHeaders();
        if (params == null || params.isEmpty()) {
            return headers;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object val = entry.getValue();
            ArrayList<String> list = new ArrayList<String>();
            if (val instanceof List) {
                List vals = (List)val;
                for (Object value : vals) {
                    if (value == null) continue;
                    list.add(value.toString());
                }
            } else if (val != null) {
                list.add(val.toString());
            }
            if (list.size() <= 0) continue;
            headers.put(entry.getKey(), list);
        }
        return headers;
    }

    public static MultiValueMap<String, String> toMultiValueMap(Map<String, Object> params) {
        LinkedMultiValueMap mvmap = new LinkedMultiValueMap();
        if (params == null || params.isEmpty()) {
            return mvmap;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object val = entry.getValue();
            ArrayList<String> list = new ArrayList<String>();
            if (val instanceof List) {
                List vals = (List)val;
                for (Object value : vals) {
                    if (value == null) continue;
                    list.add(value.toString());
                }
            } else if (val != null) {
                list.add(val.toString());
            }
            if (list.size() <= 0) continue;
            mvmap.put((Object)entry.getKey(), list);
        }
        return mvmap;
    }

    public static MultiValueMap<String, Object> toMultipartDataMap(Map<String, Object> params) {
        LinkedMultiValueMap mvmap = new LinkedMultiValueMap();
        if (params == null || params.isEmpty()) {
            return mvmap;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object val = entry.getValue();
            ArrayList list = new ArrayList();
            if (val instanceof List) {
                List vals = (List)val;
                for (Object value : vals) {
                    if (value == null) continue;
                    list.add(value);
                }
            } else if (val != null) {
                list.add(val.toString());
            }
            if (list.size() <= 0) continue;
            mvmap.put((Object)entry.getKey(), list);
        }
        return mvmap;
    }

    public static Map<String, Object> extractFormData(MultiValueMap<String, Part> params, String fileKeyPrefix, Map<String, FilePart> filePartMap) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (params == null || params.isEmpty()) {
            return m;
        }
        for (Map.Entry entry : params.entrySet()) {
            List val = (List)entry.getValue();
            if (val == null || val.size() <= 0) continue;
            if (val.size() > 1) {
                ArrayList formFieldValues = new ArrayList();
                val.stream().forEach(part -> {
                    if (part instanceof FormFieldPart) {
                        FormFieldPart p = (FormFieldPart)part;
                        formFieldValues.add(p.value());
                    } else if (part instanceof FilePart) {
                        FilePart fp = (FilePart)part;
                        String k = fileKeyPrefix + UUIDUtil.getUUID() + "-" + fp.filename();
                        formFieldValues.add(k);
                        filePartMap.put(k, fp);
                    }
                });
                if (formFieldValues.size() <= 0) continue;
                m.put((String)entry.getKey(), formFieldValues);
                continue;
            }
            if (val.get(0) instanceof FormFieldPart) {
                FormFieldPart p = (FormFieldPart)val.get(0);
                m.put((String)entry.getKey(), p.value());
                continue;
            }
            if (!(val.get(0) instanceof FilePart)) continue;
            FilePart fp = (FilePart)val.get(0);
            String k = fileKeyPrefix + UUIDUtil.getUUID() + "-" + fp.filename();
            m.put((String)entry.getKey(), k);
            filePartMap.put(k, fp);
        }
        return m;
    }

    public static void replaceWithFilePart(MultiValueMap<String, Object> params, String fileKeyPrefix, Map<String, FilePart> filePartMap) {
        if (params == null || params.isEmpty() || filePartMap == null || filePartMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : params.entrySet()) {
            List list = (List)entry.getValue();
            if (list == null || list.size() <= 0) continue;
            ArrayList<Object> newlist = new ArrayList<Object>();
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).toString().startsWith(fileKeyPrefix)) {
                    newlist.add(filePartMap.get(list.get(i).toString()));
                    continue;
                }
                newlist.add(list.get(i));
            }
            params.put(entry.getKey(), newlist);
        }
    }

    public static Map<String, Object> toHashMap(MultiValueMap<String, String> params) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (params == null || params.isEmpty()) {
            return m;
        }
        for (Map.Entry entry : params.entrySet()) {
            List val = (List)entry.getValue();
            if (val == null || val.size() <= 0) continue;
            if (val.size() > 1) {
                m.put((String)entry.getKey(), val);
                continue;
            }
            m.put((String)entry.getKey(), val.get(0));
        }
        return m;
    }

    public static Map<String, Object> headerToHashMap(HttpHeaders headers) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (headers == null || headers.isEmpty()) {
            return m;
        }
        for (Map.Entry entry : headers.entrySet()) {
            List val = (List)entry.getValue();
            if (val == null || val.size() <= 0) continue;
            if (val.size() > 1) {
                m.put(((String)entry.getKey()).toUpperCase(), val);
                continue;
            }
            m.put(((String)entry.getKey()).toUpperCase(), val.get(0));
        }
        return m;
    }

    public static Map<String, Object> upperCaseKey(Map<String, Object> m) {
        HashMap<String, Object> rs = new HashMap<String, Object>();
        if (m == null || m.isEmpty()) {
            return rs;
        }
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            rs.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        return rs;
    }

    public static MultiValueMap<String, Object> upperCaseKey(MultiValueMap<String, Object> m) {
        LinkedMultiValueMap rs = new LinkedMultiValueMap();
        if (m == null || m.isEmpty()) {
            return rs;
        }
        for (Map.Entry entry : m.entrySet()) {
            rs.put((Object)((String)entry.getKey()).toUpperCase(), entry.getValue());
        }
        return rs;
    }

    public static void set(Map<String, Object> data, String path, Object value) {
        String[] fields = path.split("\\.");
        if (fields.length < 2) {
            data.put(path, value);
        } else {
            Map<String, Object> next = data;
            for (int i = 0; i < fields.length - 1; ++i) {
                HashMap<String, Object> val = (HashMap<String, Object>)next.get(fields[i]);
                if (val == null) {
                    val = new HashMap<String, Object>();
                    next.put(fields[i], val);
                }
                if (i == fields.length - 2) {
                    val.put(fields[i + 1], value);
                    break;
                }
                next = val;
            }
        }
    }

    public static Object get(Map<String, Object> data, String path) {
        String[] fields = path.split("\\.");
        if (fields.length < 2) {
            return data.get(path);
        }
        Map next = data;
        for (int i = 0; i < fields.length - 1; ++i) {
            if (!(next.get(fields[i]) instanceof Map)) {
                return null;
            }
            Map val = (Map)next.get(fields[i]);
            if (val == null) {
                return null;
            }
            if (i == fields.length - 2) {
                return val.get(fields[i + 1]);
            }
            next = val;
        }
        return null;
    }

    public static Map<String, Object> merge(Map<String, Object> target, Map<String, Object> src) {
        if (src == null || src.isEmpty()) {
            return target;
        }
        src.forEach((key, value) -> {
            if (value != null) {
                target.merge((String)key, value, (oldValue, newValue) -> {
                    if (oldValue instanceof Map && newValue instanceof Map) {
                        oldValue = MapUtil.merge(oldValue, (Map)newValue);
                        return oldValue;
                    }
                    return newValue;
                });
            } else {
                target.put((String)key, value);
            }
        });
        return target;
    }

    public static Map<String, Object> list2Map(Object obj) {
        if (obj instanceof Map) {
            return (Map)obj;
        }
        if (obj instanceof List) {
            HashMap<String, Object> rs = new HashMap<String, Object>();
            List list = (List)obj;
            if (list == null || list.size() == 0) {
                return rs;
            }
            for (Map m : list) {
                String k = m.get(KEY).toString();
                Object v = m.get(VALUE);
                if (rs.containsKey(k)) {
                    List vals = null;
                    if (rs.get(k) instanceof List) {
                        vals = (List)rs.get(k);
                    } else {
                        vals = new ArrayList();
                        vals.add(rs.get(k));
                    }
                    vals.add(v);
                    rs.put(k, vals);
                    continue;
                }
                rs.put(k, v);
            }
            return rs;
        }
        return null;
    }

    public static MultiValueMap<String, Object> listToMultiValueMap(List<Map<String, Object>> list) {
        LinkedMultiValueMap mvmap = new LinkedMultiValueMap();
        if (list == null || list.size() == 0) {
            return mvmap;
        }
        for (Map<String, Object> m : list) {
            mvmap.add((Object)m.get(KEY).toString(), m.get(VALUE));
        }
        return mvmap;
    }
}

