/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;

public abstract class NettyDataBufferUtils
extends DataBufferUtils {
    private static NettyDataBufferFactory dataBufferFactory = new NettyDataBufferFactory(ByteBufAllocator.DEFAULT);
    public static final DataBuffer EMPTY_DATA_BUFFER = NettyDataBufferUtils.from(new byte[0]);

    private NettyDataBufferUtils() {
    }

    public static NettyDataBuffer from(String s) {
        return NettyDataBufferUtils.from(s.getBytes(StandardCharsets.UTF_8));
    }

    public static NettyDataBuffer from(byte[] bytes) {
        return (NettyDataBuffer)dataBufferFactory.wrap(bytes);
    }

    public static byte[] copyBytes(DataBuffer dataBuffer) {
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        return bytes;
    }

    public static DataBuffer copy2heap(DataBuffer dataBuffer) {
        return NettyDataBufferUtils.from(NettyDataBufferUtils.copyBytes(dataBuffer));
    }
}

