/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import com.fizzgate.util.ThreadContext;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkUtils.class);
    private static final int maxServerId = 1023;
    private static int serverId = -1;
    private static String serverIp;
    private static Set<String> serverIps;
    private static final String SERVER_IP = "SERVER_IP";
    private static final String LOCAL_IP = "127.0.0.1";

    private NetworkUtils() {
    }

    public static String getServerIp() {
        block1: {
            if (serverIp != null) break block1;
            for (String serverIp : NetworkUtils.getServerIps()) {
                if (!LOCAL_IP.equals(serverIp)) break;
            }
        }
        return serverIp;
    }

    public static synchronized Set<String> getServerIps() {
        if (serverIps.isEmpty()) {
            try {
                String ip = System.getProperty(SERVER_IP);
                if (StringUtils.isBlank((CharSequence)ip)) {
                    ip = System.getenv(SERVER_IP);
                }
                if (StringUtils.isBlank((CharSequence)ip)) {
                    Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                    while (nis.hasMoreElements()) {
                        NetworkInterface ni = nis.nextElement();
                        Enumeration<InetAddress> ias = ni.getInetAddresses();
                        while (ias.hasMoreElements()) {
                            InetAddress ia = ias.nextElement();
                            if (!ia.isSiteLocalAddress()) continue;
                            ip = ia.getHostAddress();
                            serverIps.add(ip);
                        }
                    }
                    if (serverIps.isEmpty()) {
                        InetAddress ia = InetAddress.getLocalHost();
                        ip = ia.getHostAddress();
                        serverIps.add(ip);
                    }
                } else {
                    serverIps.add(ip);
                }
                LOGGER.info("server ip: {}", serverIps);
            }
            catch (SocketException | UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return serverIps;
    }

    public static int getServerId() {
        if (serverId == -1) {
            try {
                StringBuilder b = ThreadContext.getStringBuilder();
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                while (nis.hasMoreElements()) {
                    NetworkInterface ni = nis.nextElement();
                    byte[] mac = ni.getHardwareAddress();
                    if (mac == null) continue;
                    for (int i = 0; i < mac.length; ++i) {
                        b.append(String.format("%02X", mac[i]));
                    }
                }
                serverId = b.toString().hashCode();
            }
            catch (Exception e) {
                serverId = new SecureRandom().nextInt();
                LOGGER.error(null, (Throwable)e);
            }
            LOGGER.info("server id: {}", (Object)(serverId &= 0x3FF));
        }
        return serverId;
    }

    static {
        serverIps = new LinkedHashSet<String>();
    }
}

