/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public abstract class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static Properties from(String config) {
        ByteArrayResource resource = new ByteArrayResource(config.getBytes());
        try {
            return PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String normalize(String propertyName) {
        char[] chars = propertyName.toCharArray();
        StringBuilder b = new StringBuilder(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '-') {
                b.append(Character.toUpperCase(chars[++i]));
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static Properties remove(Properties properties, String prefix) {
        Properties result = new Properties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String s = k.toString();
            int idx = s.indexOf(prefix);
            if (idx > -1) {
                s = s.substring(prefix.length() + 1);
            }
            result.setProperty(s, v.toString());
        }));
        return result;
    }

    public static void setBeanPropertyValue(Object bean, Properties properties) {
        PropertiesUtils.setBeanPropertyValue(bean, properties, null);
    }

    public static void setBeanPropertyValue(Object bean, Properties properties, Map<String, Class<?>> propertyTypeHint) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(bean);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(n, v) -> {
            String prefix;
            Class aClass;
            int dotPos;
            String propertyName = (String)n;
            if (beanWrapper.isWritableProperty(propertyName)) {
                beanWrapper.setPropertyValue(propertyName, properties.get(propertyName));
            } else if (propertyTypeHint != null && (dotPos = propertyName.lastIndexOf(46)) > -1 && (aClass = (Class)propertyTypeHint.get(prefix = propertyName.substring(0, dotPos))) != null && Map.class.isAssignableFrom(aClass)) {
                String newPropertyName = prefix + '[' + propertyName.substring(dotPos + 1) + ']';
                beanWrapper.setPropertyValue(newPropertyName, properties.get(propertyName));
            }
        }));
    }
}

