/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import com.fizzgate.config.RedisReactiveConfig;
import com.fizzgate.config.RedisReactiveProperties;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;

public abstract class ReactiveRedisHelper {
    private ReactiveRedisHelper() {
    }

    public static ReactiveRedisConnectionFactory getConnectionFactory(RedisReactiveProperties redisReactiveProperties) {
        if (redisReactiveProperties.getType() == "standalone") {
            return ReactiveRedisHelper.getConnectionFactory(redisReactiveProperties.getHost(), redisReactiveProperties.getPort(), redisReactiveProperties.getPassword(), redisReactiveProperties.getDatabase());
        }
        return ReactiveRedisHelper.getClusterConnectionFactory(redisReactiveProperties);
    }

    public static ReactiveStringRedisTemplate getStringRedisTemplate(RedisReactiveProperties redisReactiveProperties) {
        ReactiveRedisConnectionFactory connectionFactory = ReactiveRedisHelper.getConnectionFactory(redisReactiveProperties);
        return new ReactiveStringRedisTemplate(connectionFactory);
    }

    public static ReactiveRedisConnectionFactory getConnectionFactory(String host, int port, String password, int database) {
        RedisStandaloneConfiguration rsc = new RedisStandaloneConfiguration(host, port);
        if (password != null) {
            rsc.setPassword(password);
        }
        rsc.setDatabase(database);
        LettucePoolingClientConfiguration ccs = LettucePoolingClientConfiguration.builder().clientResources(RedisReactiveConfig.CLIENT_RESOURCES).clientOptions(ClientOptions.builder().publishOnScheduler(true).build()).poolConfig(new GenericObjectPoolConfig()).build();
        LettuceConnectionFactory factory = new LettuceConnectionFactory(rsc, (LettuceClientConfiguration)ccs);
        factory.afterPropertiesSet();
        return factory;
    }

    public static ReactiveStringRedisTemplate getStringRedisTemplate(String host, int port, String password, int database) {
        ReactiveRedisConnectionFactory connectionFactory = ReactiveRedisHelper.getConnectionFactory(host, port, password, database);
        return new ReactiveStringRedisTemplate(connectionFactory);
    }

    public static ReactiveRedisConnectionFactory getClusterConnectionFactory(RedisReactiveProperties redisReactiveProperties) {
        Duration timeBetweenEvictionRuns;
        int maxTotal;
        int maxIdle;
        RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration();
        String password = redisReactiveProperties.getPassword();
        if (password != null) {
            redisClusterConfiguration.setPassword(password);
        }
        redisClusterConfiguration.setClusterNodes(redisReactiveProperties.getClusterNodes());
        int maxRedirects = redisReactiveProperties.getMaxRedirects();
        if (maxRedirects > 0) {
            redisClusterConfiguration.setMaxRedirects(maxRedirects);
        }
        ClusterTopologyRefreshOptions.Builder builder = ClusterTopologyRefreshOptions.builder();
        int clusterRefreshPeriod = redisReactiveProperties.getClusterRefreshPeriod();
        builder = builder.enablePeriodicRefresh(Duration.ofSeconds(clusterRefreshPeriod));
        boolean enableAllAdaptiveRefreshTriggers = redisReactiveProperties.isEnableAllAdaptiveRefreshTriggers();
        if (enableAllAdaptiveRefreshTriggers) {
            builder = builder.enableAllAdaptiveRefreshTriggers();
        }
        ClusterTopologyRefreshOptions topologyRefreshOptions = builder.build();
        ClusterClientOptions clusterClientOptions = ClusterClientOptions.builder().timeoutOptions(TimeoutOptions.enabled((Duration)Duration.ofSeconds(clusterRefreshPeriod))).topologyRefreshOptions(topologyRefreshOptions).publishOnScheduler(true).build();
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        int minIdle = redisReactiveProperties.getMinIdle();
        if (minIdle > 0) {
            poolConfig.setMinIdle(minIdle);
        }
        if ((maxIdle = redisReactiveProperties.getMaxIdle()) > 0) {
            poolConfig.setMaxIdle(maxIdle);
        }
        if ((maxTotal = redisReactiveProperties.getMaxTotal()) > 0) {
            poolConfig.setMaxTotal(maxTotal);
        } else {
            poolConfig.setMaxTotal(poolConfig.getMaxTotal() * 2);
        }
        Duration maxWait = redisReactiveProperties.getMaxWait();
        if (maxWait != null) {
            poolConfig.setMaxWait(maxWait);
        }
        if ((timeBetweenEvictionRuns = redisReactiveProperties.getTimeBetweenEvictionRuns()) != null) {
            poolConfig.setTimeBetweenEvictionRuns(timeBetweenEvictionRuns);
        }
        LettucePoolingClientConfiguration clientConfig = LettucePoolingClientConfiguration.builder().clientResources(RedisReactiveConfig.CLIENT_RESOURCES).poolConfig(poolConfig).readFrom(redisReactiveProperties.getReadFrom()).clientOptions((ClientOptions)clusterClientOptions).build();
        LettuceConnectionFactory reactiveRedisConnectionFactory = new LettuceConnectionFactory(redisClusterConfiguration, (LettuceClientConfiguration)clientConfig);
        reactiveRedisConnectionFactory.afterPropertiesSet();
        return reactiveRedisConnectionFactory;
    }

    public static ReactiveStringRedisTemplate getClusterStringRedisTemplate(RedisReactiveProperties redisReactiveProperties) {
        ReactiveRedisConnectionFactory connectionFactory = ReactiveRedisHelper.getClusterConnectionFactory(redisReactiveProperties);
        return new ReactiveStringRedisTemplate(connectionFactory);
    }
}

