/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import com.fizzgate.util.JacksonUtils;
import java.util.Collections;
import java.util.Map;

public class Result<D> {
    public static final int SUCC = 1;
    public static final int FAIL = 0;
    public int code = -1;
    public String msg;
    public D data;
    public Throwable t;
    public Map<Object, Object> context = Collections.emptyMap();

    public Result() {
    }

    public Result(int code, String msg, D data, Throwable t, Map<Object, Object> context) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.t = t;
        this.context = context;
    }

    public static <D> Result<D> succ() {
        return new Result<Object>(1, null, null, null, null);
    }

    public static <D> Result<D> succ(D data) {
        Result<D> r = Result.succ();
        r.data = data;
        return r;
    }

    public static <D> Result<D> succ(D data, Map<Object, Object> context) {
        Result<D> r = Result.succ(data);
        r.context = context;
        return r;
    }

    public static <D> Result<D> fail() {
        return new Result<Object>(0, null, null, null, null);
    }

    public static <D> Result<D> fail(String msg) {
        Result<D> r = Result.fail();
        r.msg = msg;
        return r;
    }

    public static <D> Result<D> fail(String msg, Map<Object, Object> context) {
        Result<D> r = Result.fail(msg);
        r.context = context;
        return r;
    }

    public static <D> Result<D> fail(Throwable t) {
        Result<D> r = Result.fail();
        r.t = t;
        return r;
    }

    public static <D> Result<D> fail(Throwable t, Map<Object, Object> context) {
        Result<D> r = Result.fail(t);
        r.context = context;
        return r;
    }

    public static <D> Result<D> with(int code) {
        return new Result<Object>(code, null, null, null, null);
    }

    public static <D> Result<D> with(int code, Map<Object, Object> context) {
        Result<D> r = Result.with(code);
        r.context = context;
        return r;
    }

    public static <D> Result<D> with(int code, String msg) {
        Result<D> r = Result.with(code);
        r.msg = msg;
        return r;
    }

    public static <D> Result<D> with(int code, String msg, Map<Object, Object> context) {
        Result<String> r = Result.with(code, msg);
        r.context = context;
        return r;
    }

    public static <D> Result<D> with(int code, Throwable t) {
        Result<D> r = Result.with(code);
        r.t = t;
        return r;
    }

    public static <D> Result<D> with(int code, Throwable t, Map<Object, Object> context) {
        Result<Throwable> r = Result.with(code, t);
        r.context = context;
        return r;
    }

    public static <D> Result<D> with(int code, D data) {
        Result<D> r = Result.with(code);
        r.data = data;
        return r;
    }

    public static <D> Result<D> with(int code, D data, Map<Object, Object> context) {
        Result<D> r = Result.with(code, data);
        r.context = context;
        return r;
    }

    public String toString() {
        return JacksonUtils.writeValueAsString(this);
    }
}

