/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.Script;
import com.fizzgate.util.ThreadContext;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.springframework.core.io.ClassPathResource;

public abstract class ScriptUtils {
    public static final String JAVA_SCRIPT = "javascript";
    public static final String GROOVY = "groovy";
    private static ScriptEngineManager engineManger;
    private static final String jsFuncName = "dyFunc";
    private static final String clazz = "clazz";
    private static final String resJsonStr = "resJsonStr";
    private static final String COMMON_JS_PATH = "js/common.js";
    public static Map<Long, Long> recreateJavascriptEngineSignalMap;

    private ScriptUtils() {
    }

    private static ScriptEngine createJavascriptEngine() throws ScriptException {
        ScriptEngine eng = engineManger.getEngineByName(JAVA_SCRIPT);
        try {
            File f = new File(COMMON_JS_PATH);
            if (f.exists()) {
                eng.eval(new FileReader(COMMON_JS_PATH));
                return eng;
            }
            ClassPathResource res = new ClassPathResource(COMMON_JS_PATH);
            eng.eval(new InputStreamReader(res.getInputStream()));
            return eng;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    public static ScriptEngine getScriptEngine(String type) throws ScriptException {
        if (GROOVY.equals(type)) {
            ScriptEngine groovyEngine = (ScriptEngine)ThreadContext.get(GROOVY);
            if (groovyEngine == null) {
                groovyEngine = engineManger.getEngineByName(GROOVY);
                ThreadContext.set(GROOVY, groovyEngine);
            }
            return groovyEngine;
        }
        if (JAVA_SCRIPT.equals(type)) {
            ScriptEngine javascriptEngine;
            long tid = Thread.currentThread().getId();
            Long signal = recreateJavascriptEngineSignalMap.get(tid);
            if (signal == null) {
                javascriptEngine = ScriptUtils.createJavascriptEngine();
                recreateJavascriptEngineSignalMap.put(tid, tid);
                ThreadContext.set(JAVA_SCRIPT, javascriptEngine);
            } else {
                javascriptEngine = (ScriptEngine)ThreadContext.get(JAVA_SCRIPT);
            }
            return javascriptEngine;
        }
        throw new ScriptException("unknown script engine type: " + type);
    }

    public static Object execute(Script script) throws ScriptException {
        return ScriptUtils.execute(script, null);
    }

    public static Object execute(Script script, Map<String, Object> context) throws ScriptException {
        String type = script.getType();
        ScriptEngine engine = ScriptUtils.getScriptEngine(type);
        String src = script.getSource();
        if (GROOVY.equals(type)) {
            if (context == null) {
                return engine.eval(src);
            }
            Bindings bis = engine.createBindings();
            bis.putAll((Map<? extends String, ? extends Object>)context);
            return engine.eval(src, bis);
        }
        engine.eval(src);
        Invocable invocable = (Invocable)((Object)engine);
        String paramsJsonStr = "";
        try {
            if (context != null) {
                paramsJsonStr = JacksonUtils.writeValueAsString(context);
            }
            return invocable.invokeFunction(jsFuncName, paramsJsonStr);
        }
        catch (NoSuchMethodException | RuntimeException e) {
            throw new ScriptException(e);
        }
    }

    static {
        recreateJavascriptEngineSignalMap = new HashMap<Long, Long>();
        engineManger = new ScriptEngineManager();
    }
}

