/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public abstract class SymmetricCryptoUtils {
    private SymmetricCryptoUtils() {
    }

    public static Cipher createCipher(SymmetricAlgorithm algorithm, String key, int mode) {
        byte[] keyBytes = SecureUtil.decode((String)key);
        String algorithmName = algorithm.getValue();
        SecretKey secretKey = KeyUtil.generateKey((String)algorithmName, (byte[])keyBytes);
        Cipher cipher = SecureUtil.createCipher((String)algorithmName);
        byte[] iv = cipher.getIV();
        AlgorithmParameterSpec parameterSpec = null;
        if (StrUtil.startWithIgnoreCase((CharSequence)algorithmName, (CharSequence)"AES")) {
            if (iv != null) {
                parameterSpec = new IvParameterSpec(iv);
            }
        } else if (StrUtil.startWithIgnoreCase((CharSequence)algorithmName, (CharSequence)"PBE")) {
            if (null == iv) {
                iv = RandomUtil.randomBytes((int)8);
            }
            parameterSpec = new PBEParameterSpec(iv, 100);
        }
        try {
            if (null == parameterSpec) {
                cipher.init(mode, secretKey);
            } else {
                cipher.init(mode, (Key)secretKey, parameterSpec);
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        return cipher;
    }

    public static boolean isZeroPadding(SymmetricAlgorithm algorithm) {
        String algorithmName = algorithm.getValue();
        return algorithmName.contains(Padding.ZeroPadding.name());
    }

    public static byte[] paddingWith0(byte[] data, int blockSize) {
        int length = data.length;
        int remainLength = length % blockSize;
        if (remainLength > 0) {
            return ArrayUtil.resize((byte[])data, (int)(length + blockSize - remainLength));
        }
        return data;
    }

    public static byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (blockSize > 0 && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return ArrayUtil.resize((byte[])data, (int)(i + 1));
        }
        return data;
    }
}

