/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import com.fizzgate.util.SymmetricCryptoUtils;
import java.nio.charset.Charset;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class SymmetricDecryptor {
    public final SymmetricAlgorithm algorithm;
    public final String secretKey;
    private final Cipher cipher;
    private final boolean isZeroPadding;

    public SymmetricDecryptor(SymmetricAlgorithm algorithm, String key) {
        this.algorithm = algorithm;
        this.secretKey = key;
        this.cipher = SymmetricCryptoUtils.createCipher(algorithm, key, 2);
        this.isZeroPadding = SymmetricCryptoUtils.isZeroPadding(algorithm);
    }

    public String decrypt(String data) {
        byte[] decode = SecureUtil.decode((String)data);
        return StrUtil.str((byte[])this.decrypt(decode), (Charset)CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decrypt(byte[] data) {
        byte[] decryptData;
        int blockSize = this.cipher.getBlockSize();
        try {
            decryptData = this.cipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        if (this.isZeroPadding) {
            return SymmetricCryptoUtils.removePadding(decryptData, blockSize);
        }
        return decryptData;
    }
}

