/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import com.fizzgate.util.SymmetricCryptoUtils;
import java.nio.charset.Charset;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class SymmetricEncryptor {
    public final SymmetricAlgorithm algorithm;
    public final String secretKey;
    private final Cipher cipher;
    private final boolean isZeroPadding;

    public SymmetricEncryptor(SymmetricAlgorithm algorithm, String key) {
        this.algorithm = algorithm;
        this.secretKey = key;
        this.cipher = SymmetricCryptoUtils.createCipher(algorithm, key, 1);
        this.isZeroPadding = SymmetricCryptoUtils.isZeroPadding(algorithm);
    }

    public byte[] encrypt(byte[] data) {
        if (this.isZeroPadding) {
            data = SymmetricCryptoUtils.paddingWith0(data, this.cipher.getBlockSize());
        }
        try {
            return this.cipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encrypt(String data) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)CharsetUtil.CHARSET_UTF_8));
    }

    public String base64encrypt(String data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    public String hexEncrypt(String data) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data));
    }
}

