/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;

public class UrlTransformUtils {
    private static final Logger log = LoggerFactory.getLogger(UrlTransformUtils.class);
    public static final FizzGatewayUrlAntPathMatcher ANT_PATH_MATCHER = new FizzGatewayUrlAntPathMatcher();

    private UrlTransformUtils() {
    }

    public static boolean isAntPathPattern(String path) {
        boolean uriVar = false;
        int pl = path.length();
        for (int i = 0; i < pl; ++i) {
            char c = path.charAt(i);
            if (c == '*' || c == '?') {
                return true;
            }
            if (c == '{') {
                uriVar = true;
                continue;
            }
            if (c != '}' || !uriVar) continue;
            return true;
        }
        return false;
    }

    public static String transform(String frontendPath, String backendPath, String reqPath) {
        String bp = backendPath;
        Map variables = ANT_PATH_MATCHER.extractUriTemplateVariables(frontendPath, reqPath);
        for (Map.Entry entry : variables.entrySet()) {
            backendPath = backendPath.replaceAll("\\{" + Matcher.quoteReplacement((String)entry.getKey()) + "}", Matcher.quoteReplacement((String)entry.getValue()));
        }
        if (backendPath.indexOf(123) != -1) {
            backendPath = backendPath.replaceAll("\\{[^/]*}", "");
        }
        return backendPath;
    }

    public static class FizzGatewayUrlAntPathMatcher
    extends AntPathMatcher {
        private static final String DEFAULT_PATH_SEPARATOR = "#";
        private static final int CACHE_TURNOFF_THRESHOLD = 65536;
        private volatile Boolean cachePatterns;
        private final Map<String, String> replaceDoubleStarPatternCache = new ConcurrentHashMap<String, String>(256);
        private final Map<String, String[]> tokenizedPatternCache = new ConcurrentHashMap<String, String[]>(256);
        final Map<String, AntPathMatcher.AntPathStringMatcher> stringMatcherCache = new ConcurrentHashMap<String, AntPathMatcher.AntPathStringMatcher>(256);
        private boolean caseSensitive = true;
        private static AntPathMatcher DEFAULT_ANT_PATH_MATCHER = new AntPathMatcher();

        public FizzGatewayUrlAntPathMatcher() {
            super(DEFAULT_PATH_SEPARATOR);
        }

        public void setPathSeparator(String pathSeparator) {
            throw new RuntimeException("operation not support");
        }

        public void setTrimTokens(boolean trimTokens) {
            throw new RuntimeException("operation not support");
        }

        public void setCaseSensitive(boolean caseSensitive) {
            super.setCaseSensitive(caseSensitive);
            this.caseSensitive = caseSensitive;
        }

        public void setCachePatterns(boolean cachePatterns) {
            super.setCachePatterns(cachePatterns);
            this.cachePatterns = cachePatterns;
        }

        protected AntPathMatcher.AntPathStringMatcher getStringMatcher(String pattern) {
            AntPathMatcher.AntPathStringMatcher matcher = null;
            Boolean cachePatterns = this.cachePatterns;
            if (cachePatterns == null || cachePatterns.booleanValue()) {
                matcher = this.stringMatcherCache.get(pattern);
            }
            if (matcher == null) {
                matcher = new FizzGatewayAntPathStringMatcher(pattern, this.caseSensitive);
                if (cachePatterns == null && this.stringMatcherCache.size() >= 65536) {
                    this.deactivatePatternCache();
                    return matcher;
                }
                if (cachePatterns == null || cachePatterns.booleanValue()) {
                    this.stringMatcherCache.put(pattern, matcher);
                }
            }
            return matcher;
        }

        protected String[] tokenizePattern(String pattern) {
            String[] tokenized = null;
            Boolean cachePatterns = this.cachePatterns;
            if (cachePatterns == null || cachePatterns.booleanValue()) {
                tokenized = this.tokenizedPatternCache.get(pattern);
            }
            if (tokenized == null) {
                tokenized = this.tokenizePath(pattern);
                if (cachePatterns == null && this.tokenizedPatternCache.size() >= 65536) {
                    this.deactivatePatternCache();
                    return tokenized;
                }
                if (cachePatterns == null || cachePatterns.booleanValue()) {
                    this.tokenizedPatternCache.put(pattern, tokenized);
                }
            }
            return tokenized;
        }

        private void deactivatePatternCache() {
            this.cachePatterns = false;
            this.tokenizedPatternCache.clear();
            this.stringMatcherCache.clear();
            this.replaceDoubleStarPatternCache.clear();
        }

        public String extractPathWithinPattern(String pattern, String path) {
            return DEFAULT_ANT_PATH_MATCHER.extractPathWithinPattern(pattern, path);
        }

        public String combine(String pattern1, String pattern2) {
            return DEFAULT_ANT_PATH_MATCHER.combine(pattern1, pattern2);
        }

        protected boolean doMatch(String pattern, String path, boolean fullMatch, Map<String, String> uriTemplateVariables) {
            String replaceDoubleStarPattern = null;
            if (pattern != null) {
                replaceDoubleStarPattern = this.getReplaceDoubleStarPattern(pattern);
            }
            return super.doMatch(replaceDoubleStarPattern, path, fullMatch, uriTemplateVariables);
        }

        private String getReplaceDoubleStarPattern(String pattern) {
            String replaceDoubleStarPattern = null;
            Boolean cachePatterns = this.cachePatterns;
            if (cachePatterns == null || cachePatterns.booleanValue()) {
                replaceDoubleStarPattern = this.replaceDoubleStarPatternCache.get(pattern);
            }
            if (replaceDoubleStarPattern == null) {
                replaceDoubleStarPattern = pattern.replaceAll("/\\*\\*$", "/{\\$:.*}").replaceAll("/\\*\\*/", "/{\\$:.*}/").replaceAll("^\\*\\*/", "{\\$:.*}/");
                if (cachePatterns == null && this.replaceDoubleStarPatternCache.size() >= 65536) {
                    this.deactivatePatternCache();
                    return replaceDoubleStarPattern;
                }
                if (cachePatterns == null || cachePatterns.booleanValue()) {
                    this.replaceDoubleStarPatternCache.put(pattern, replaceDoubleStarPattern);
                }
            }
            return replaceDoubleStarPattern;
        }

        protected static class FizzGatewayAntPathStringMatcher
        extends AntPathMatcher.AntPathStringMatcher {
            private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?\\}|[^{}]|\\\\[{}])+?)\\}");
            private static final String DEFAULT_VARIABLE_PATTERN = "([^/]*)";
            private final Pattern pattern;
            private final List<String> variableNames = new LinkedList<String>();
            private final String ANONYMOUS_PLACEHOLDER = "$";

            public FizzGatewayAntPathStringMatcher(String pattern) {
                this(pattern, true);
            }

            public FizzGatewayAntPathStringMatcher(String pattern, boolean caseSensitive) {
                super(pattern, caseSensitive);
                StringBuilder patternBuilder = new StringBuilder();
                Matcher matcher = GLOB_PATTERN.matcher(pattern);
                int end = 0;
                while (matcher.find()) {
                    patternBuilder.append(this.quote(pattern, end, matcher.start()));
                    String match = matcher.group();
                    if ("?".equals(match)) {
                        patternBuilder.append('(');
                        patternBuilder.append('.');
                        patternBuilder.append(')');
                        this.variableNames.add("$");
                    } else if ("*".equals(match)) {
                        patternBuilder.append(DEFAULT_VARIABLE_PATTERN);
                        this.variableNames.add("$");
                    } else if (match.startsWith("{") && match.endsWith("}")) {
                        int colonIdx = match.indexOf(58);
                        if (colonIdx == -1) {
                            patternBuilder.append(DEFAULT_VARIABLE_PATTERN);
                            this.variableNames.add(matcher.group(1));
                        } else {
                            String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                            patternBuilder.append('(');
                            patternBuilder.append(variablePattern);
                            patternBuilder.append(')');
                            String variableName = match.substring(1, colonIdx);
                            this.variableNames.add(variableName);
                        }
                    }
                    end = matcher.end();
                }
                patternBuilder.append(this.quote(pattern, end, pattern.length()));
                this.pattern = caseSensitive ? Pattern.compile(patternBuilder.toString()) : Pattern.compile(patternBuilder.toString(), 2);
            }

            private String quote(String s, int start, int end) {
                if (start == end) {
                    return "";
                }
                return Pattern.quote(s.substring(start, end));
            }

            public boolean matchStrings(String str, @Nullable Map<String, String> uriTemplateVariables) {
                Matcher matcher = this.pattern.matcher(str);
                if (matcher.matches()) {
                    if (uriTemplateVariables != null) {
                        if (this.variableNames.size() != matcher.groupCount()) {
                            throw new IllegalArgumentException("The number of capturing groups in the pattern segment " + this.pattern + " does not match the number of URI template variables it defines, which can occur if capturing groups are used in a URI template regex. Use non-capturing groups instead.");
                        }
                        for (int i = 1; i <= matcher.groupCount(); ++i) {
                            String name = this.variableNames.get(i - 1);
                            String value = matcher.group(i);
                            if (!"$".equals(name)) {
                                uriTemplateVariables.put(name, value);
                            }
                            uriTemplateVariables.put("$" + i, value);
                        }
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

