/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.xml;

import java.util.ArrayList;
import java.util.HashMap;

public class Tag {
    private String mPath;
    private String mName;
    private ArrayList<Tag> mChildren = new ArrayList();
    private String mContent;

    Tag(String path, String name) {
        this.mPath = path;
        this.mName = name;
    }

    void addChild(Tag tag) {
        this.mChildren.add(tag);
    }

    void setContent(String content) {
        boolean hasContent = false;
        if (content != null) {
            for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                if (c == ' ' || c == '\n') continue;
                hasContent = true;
                break;
            }
        }
        if (hasContent) {
            this.mContent = content;
        }
    }

    String getName() {
        return this.mName;
    }

    String getContent() {
        return this.mContent;
    }

    ArrayList<Tag> getChildren() {
        return this.mChildren;
    }

    boolean hasChildren() {
        return this.mChildren.size() > 0;
    }

    int getChildrenCount() {
        return this.mChildren.size();
    }

    Tag getChild(int index) {
        if (index >= 0 && index < this.mChildren.size()) {
            return this.mChildren.get(index);
        }
        return null;
    }

    HashMap<String, ArrayList<Tag>> getGroupedElements() {
        HashMap<String, ArrayList<Tag>> groups = new HashMap<String, ArrayList<Tag>>();
        for (Tag child : this.mChildren) {
            String key = child.getName();
            ArrayList<Tag> group = groups.get(key);
            if (group == null) {
                group = new ArrayList();
                groups.put(key, group);
            }
            group.add(child);
        }
        return groups;
    }

    String getPath() {
        return this.mPath;
    }

    public String toString() {
        return "Tag: " + this.mName + ", " + this.mChildren.size() + " children, Content: " + this.mContent;
    }
}

