/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import java.net.URI;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;

public class ApolloLog4j2ConfigurationFactory
extends ConfigurationFactory {
    private static final String LOG4J2_NAMESPACE = "log4j2";

    protected String[] getSupportedTypes() {
        return new String[]{"*"};
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.getConfiguration(loggerContext, source.toString(), null);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        Config config = ConfigService.getConfig((String)LOG4J2_NAMESPACE);
        Set propertyNames = config.getPropertyNames();
        Properties properties = new Properties();
        for (String propertyName : propertyNames) {
            String propertyValue = config.getProperty(propertyName, null);
            properties.setProperty(propertyName, propertyValue);
        }
        config.addChangeListener((ConfigChangeListener)new Log4j2ConfigChangeListener(properties));
        return new PropertiesConfigurationBuilder().setRootProperties(this.copyProperties(properties)).setLoggerContext(loggerContext).build();
    }

    private Properties copyProperties(Properties properties) {
        Properties newProperties = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            newProperties.put(propertyName, properties.getProperty(propertyName));
        }
        return newProperties;
    }

    private class Log4j2ConfigChangeListener
    implements ConfigChangeListener {
        private Properties configProperties;

        Log4j2ConfigChangeListener(Properties configProperties) {
            this.configProperties = configProperties;
        }

        public void onChange(ConfigChangeEvent changeEvent) {
            for (String changedKey : changeEvent.changedKeys()) {
                ConfigChange configChange = changeEvent.getChange(changedKey);
                String newValue = configChange.getNewValue();
                if (newValue != null) {
                    this.configProperties.put(changedKey, newValue);
                    continue;
                }
                this.configProperties.remove(changedKey);
            }
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            PropertiesConfiguration newConfiguration = new PropertiesConfigurationBuilder().setRootProperties(ApolloLog4j2ConfigurationFactory.this.copyProperties(this.configProperties)).setLoggerContext(ctx).build();
            ctx.setConfiguration((Configuration)newConfiguration);
        }
    }
}

