/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.beans.factory.config;

import com.fizzgate.beans.factory.config.FizzEnvironmentPostProcessor;
import com.fizzgate.context.config.annotation.FizzRefreshScope;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ReflectionUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;

public class FizzBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware,
ApplicationContextAware,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(FizzBeanFactoryPostProcessor.class);
    private static ApplicationContext applicationContext;
    private ConfigurableEnvironment environment;
    private final Map<String, String> property2beanMap = new HashMap<String, String>();
    private ReactiveStringRedisTemplate reactiveStringRedisTemplate;

    protected static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String fizzConfigEnable = this.environment.getProperty("fizz.config.enable", "true");
        if (fizzConfigEnable.equals("true")) {
            Map<String, Object> sources = FizzEnvironmentPostProcessor.getSources();
            MapPropertySource fizzPropertySource = new MapPropertySource("FizzPropertySourceAfterBeanFactory", sources);
            this.environment.getPropertySources().addFirst((PropertySource)fizzPropertySource);
            this.initBeanProperty2beanMap(beanFactory);
        }
    }

    private void initBeanProperty2beanMap(ConfigurableListableBeanFactory beanFactory) {
        ClassLoader beanClassLoader = beanFactory.getBeanClassLoader();
        Iterator beanNamesIterator = beanFactory.getBeanNamesIterator();
        while (beanNamesIterator.hasNext()) {
            String beanName = (String)beanNamesIterator.next();
            if (!beanName.startsWith("scopedTarget.")) continue;
            AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)beanFactory.getBeanDefinition(beanName);
            try {
                beanDefinition.resolveBeanClass(beanClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            Class beanClass = null;
            try {
                beanClass = beanDefinition.getBeanClass();
            }
            catch (IllegalStateException e) {
                LOGGER.warn("get {} bean class exception: {}", (Object)beanName, (Object)e.getMessage());
                continue;
            }
            FizzRefreshScope an = beanClass.getAnnotation(FizzRefreshScope.class);
            if (an == null) continue;
            ReflectionUtils.doWithFields((Class)beanClass, field -> {
                Value annotation = field.getAnnotation(Value.class);
                if (annotation != null) {
                    this.property2beanMap.put(this.extractPlaceholderKey(annotation.value()), beanName);
                }
            });
            ReflectionUtils.doWithMethods((Class)beanClass, method -> {
                Value annotation = method.getAnnotation(Value.class);
                if (annotation != null) {
                    this.property2beanMap.put(this.extractPlaceholderKey(annotation.value()), beanName);
                }
            });
        }
        LOGGER.info("fizz refresh scope property to bean map: {}", (Object)JacksonUtils.writeValueAsString(this.property2beanMap));
    }

    private String extractPlaceholderKey(String propertyPlaceholder) {
        int begin = 2;
        int end = propertyPlaceholder.indexOf(58);
        if (end < 0) {
            end = propertyPlaceholder.indexOf(125);
        }
        return propertyPlaceholder.substring(begin, end);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        FizzBeanFactoryPostProcessor.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public String getBean(String property) {
        return this.property2beanMap.get(property);
    }
}

