/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.beans.factory.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fizzgate.beans.factory.config.FizzBeanFactoryPostProcessor;
import com.fizzgate.config.RedisReactiveProperties;
import com.fizzgate.context.event.FizzRefreshEvent;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ReactiveRedisHelper;
import com.fizzgate.util.Result;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FizzEnvironmentPostProcessor
implements EnvironmentPostProcessor,
SmartApplicationListener,
Ordered {
    private static final DeferredLog LOGGER = new DeferredLog();
    private static Logger LOG = null;
    private static final Map<String, Object> sources = new HashMap<String, Object>();
    private ConfigurableEnvironment environment;
    private ReactiveStringRedisTemplate reactiveStringRedisTemplate;

    protected static Map<String, Object> getSources() {
        return sources;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String fizzConfigEnable = environment.getProperty("fizz.config.enable", "true");
        if (fizzConfigEnable.equals("true")) {
            String host = environment.getProperty("aggregate.redis.host");
            String clusterNodes = environment.getProperty("aggregate.redis.clusterNodes");
            if (StringUtils.isNotBlank((CharSequence)host) || StringUtils.isNotBlank((CharSequence)clusterNodes)) {
                this.environment = environment;
                this.initReactiveStringRedisTemplate();
                this.initFizzPropertySource();
            }
        }
    }

    private void initReactiveStringRedisTemplate() {
        RedisReactiveProperties redisReactiveProperties = new RedisReactiveProperties(){};
        String host = this.environment.getProperty("aggregate.redis.host");
        if (StringUtils.isBlank((CharSequence)host)) {
            redisReactiveProperties.setType("cluster");
            redisReactiveProperties.setClusterNodes(this.environment.getProperty("aggregate.redis.clusterNodes"));
        } else {
            redisReactiveProperties.setHost(host);
            redisReactiveProperties.setPort(Integer.parseInt(this.environment.getProperty("aggregate.redis.port")));
            redisReactiveProperties.setDatabase(Integer.parseInt(this.environment.getProperty("aggregate.redis.database")));
        }
        String password = this.environment.getProperty("aggregate.redis.password");
        if (StringUtils.isNotBlank((CharSequence)password)) {
            redisReactiveProperties.setPassword(password);
        }
        this.reactiveStringRedisTemplate = ReactiveRedisHelper.getStringRedisTemplate((RedisReactiveProperties)redisReactiveProperties);
    }

    private void initFizzPropertySource() {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        MapPropertySource fizzPropertySource = new MapPropertySource("FizzPropertySourceAfterEnv", sources);
        propertySources.addFirst((PropertySource)fizzPropertySource);
        Result result = Result.succ();
        Flux fizzConfigs = this.reactiveStringRedisTemplate.opsForHash().entries((Object)"fizz_config");
        fizzConfigs.collectList().defaultIfEmpty(Collections.emptyList()).flatMap(es -> {
            if (es.isEmpty()) {
                LOGGER.info((Object)"no fizz configs");
            } else {
                String value = null;
                try {
                    for (Map.Entry e : es) {
                        String key = (String)e.getKey();
                        value = (String)e.getValue();
                        Map config = (Map)JacksonUtils.readValue((String)value, (TypeReference)new TypeReference<Map<String, Object>>(){});
                        sources.put(key, config.get(key));
                    }
                }
                catch (Throwable t) {
                    result.code = 0;
                    result.msg = "init fizz configs error, json: " + value;
                    result.t = t;
                }
            }
            return Mono.empty();
        }).onErrorReturn(throwable -> {
            result.code = 0;
            result.msg = "init fizz configs error";
            result.t = throwable;
            return true;
        }, (Object)result).block();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
        if (!sources.isEmpty()) {
            LOGGER.info((Object)("fizz configs: " + JacksonUtils.writeValueAsString(sources)));
        }
        String channel = "fizz_config_channel";
        this.reactiveStringRedisTemplate.listenToChannel(new String[]{channel}).doOnError(t -> {
            result.code = 0;
            result.msg = "lsn " + channel + " channel error";
            result.t = t;
            LOGGER.error((Object)("lsn channel " + channel + " error"), t);
        }).doOnSubscribe(s -> LOGGER.info((Object)("success to lsn on " + channel))).doOnNext(msg -> {
            if (LOG == null) {
                LOG = LoggerFactory.getLogger(FizzEnvironmentPostProcessor.class);
            }
            String message = (String)msg.getMessage();
            try {
                HashMap<String, Object> changedPropertyValueMap = new HashMap<String, Object>();
                List changes = (List)JacksonUtils.readValue((String)message, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                for (Map change : changes) {
                    int isDeleted = (Integer)change.remove("isDeleted");
                    Map.Entry propertyValue = change.entrySet().iterator().next();
                    String property = (String)propertyValue.getKey();
                    Object v = null;
                    if (isDeleted == 1) {
                        sources.remove(property);
                    } else {
                        v = propertyValue.getValue();
                        sources.put(property, v);
                    }
                    changedPropertyValueMap.put(property, v);
                }
                LOG.info("new fizz configs: " + JacksonUtils.writeValueAsString(sources));
                ApplicationContext applicationContext = FizzBeanFactoryPostProcessor.getApplicationContext();
                FizzRefreshEvent refreshEvent = new FizzRefreshEvent(applicationContext, 1, changedPropertyValueMap);
                applicationContext.publishEvent((ApplicationEvent)refreshEvent);
            }
            catch (Throwable t) {
                LOG.error("update fizz config " + message + " error", t);
            }
        }).subscribe();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationPreparedEvent.class.isAssignableFrom(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            LOGGER.replayTo(FizzEnvironmentPostProcessor.class);
        }
    }
}

