/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.config.AggregateRedisConfigProperties;
import com.fizzgate.config.RedisReactiveConfig;
import com.fizzgate.config.RedisReactiveProperties;
import com.fizzgate.log.LogSendAppender;
import com.fizzgate.log.RedisLogSendServiceImpl;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ReactiveRedisMessageListenerContainer;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.session.data.redis.config.annotation.SpringSessionRedisConnectionFactory;

@Configuration
public class AggregateRedisConfig
extends RedisReactiveConfig {
    static final String AGGREGATE_REACTIVE_REDIS_PROPERTIES = "aggregateReactiveRedisProperties";
    private static final String AGGREGATE_REACTIVE_REDIS_CONNECTION_FACTORY = "aggregateReactiveRedisConnectionFactory";
    public static final String AGGREGATE_REACTIVE_REDIS_TEMPLATE = "aggregateReactiveRedisTemplate";
    public static final String AGGREGATE_REACTIVE_REDIS_MESSAGE_LISTENER_CONTAINER = "aggregateReactiveRedisMessageListenerContainer";
    private static final String SEND_LOG_TYPE_REDIS = "redis";
    public static final String AGGREGATE_REDIS_PREFIX = "aggregate.redis";
    public static ProxyLettuceConnectionFactory proxyLettuceConnectionFactory;
    @Resource
    private AggregateRedisConfigProperties aggregateRedisConfigProperties;

    public AggregateRedisConfig(@Qualifier(value="aggregateReactiveRedisProperties") RedisReactiveProperties properties) {
        super(properties);
    }

    @Bean(value={"aggregateReactiveRedisConnectionFactory"})
    public ReactiveRedisConnectionFactory lettuceConnectionFactory() {
        LettuceConnectionFactory lettuceConnectionFactory = (LettuceConnectionFactory)super.lettuceConnectionFactory();
        if (SEND_LOG_TYPE_REDIS.equals(this.aggregateRedisConfigProperties.getSendLogType())) {
            proxyLettuceConnectionFactory = new ProxyLettuceConnectionFactory(lettuceConnectionFactory);
            proxyLettuceConnectionFactory.afterPropertiesSet();
            return proxyLettuceConnectionFactory;
        }
        return lettuceConnectionFactory;
    }

    @Bean(value={"aggregateReactiveRedisTemplate"})
    public ReactiveStringRedisTemplate reactiveStringRedisTemplate(@Qualifier(value="aggregateReactiveRedisConnectionFactory") ReactiveRedisConnectionFactory factory) {
        ReactiveStringRedisTemplate reactiveStringRedisTemplate = super.reactiveStringRedisTemplate(factory);
        reactiveStringRedisTemplate.getConnectionFactory().getReactiveConnection().ping().block();
        if (SEND_LOG_TYPE_REDIS.equals(this.aggregateRedisConfigProperties.getSendLogType())) {
            LogSendAppender.logSendService = new RedisLogSendServiceImpl(this.aggregateRedisConfigProperties, this, reactiveStringRedisTemplate);
        }
        return reactiveStringRedisTemplate;
    }

    @Bean(value={"aggregateReactiveRedisMessageListenerContainer"})
    public ReactiveRedisMessageListenerContainer aggregateReactiveRedisMessageListenerContainer(@Qualifier(value="aggregateReactiveRedisConnectionFactory") ReactiveRedisConnectionFactory factory) {
        return new ReactiveRedisMessageListenerContainer(factory);
    }

    @Bean
    @SpringSessionRedisConnectionFactory
    public LettuceConnectionFactory springSessionRedisConnectionFactory() {
        return (LettuceConnectionFactory)super.lettuceConnectionFactory();
    }

    @Bean(value={"springSessionDefaultRedisSerializer"})
    public RedisSerializer<Object> defaultRedisSerializer() {
        return new GenericJackson2JsonRedisSerializer();
    }

    @Bean
    @Primary
    public RedisTemplate<Object, Object> redisTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)this.lettuceConnectionFactory());
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        return template;
    }

    public static class ProxyLettuceConnectionFactory
    implements RedisConnectionFactory,
    ReactiveRedisConnectionFactory {
        private LettuceConnectionFactory lettuceConnectionFactory;

        ProxyLettuceConnectionFactory(LettuceConnectionFactory lettuceConnectionFactory) {
            this.lettuceConnectionFactory = lettuceConnectionFactory;
        }

        public void destroy() {
            this.lettuceConnectionFactory.destroy();
        }

        void afterPropertiesSet() {
            this.lettuceConnectionFactory.afterPropertiesSet();
        }

        public ReactiveRedisConnection getReactiveConnection() {
            return this.lettuceConnectionFactory.getReactiveConnection();
        }

        public ReactiveRedisClusterConnection getReactiveClusterConnection() {
            return this.lettuceConnectionFactory.getReactiveClusterConnection();
        }

        public RedisConnection getConnection() {
            return this.lettuceConnectionFactory.getConnection();
        }

        public RedisClusterConnection getClusterConnection() {
            return this.lettuceConnectionFactory.getClusterConnection();
        }

        public boolean getConvertPipelineAndTxResults() {
            return this.lettuceConnectionFactory.getConvertPipelineAndTxResults();
        }

        public RedisSentinelConnection getSentinelConnection() {
            return this.lettuceConnectionFactory.getSentinelConnection();
        }

        public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
            return this.lettuceConnectionFactory.translateExceptionIfPossible(ex);
        }
    }

    @ConfigurationProperties(prefix="aggregate.redis")
    @Configuration(value="aggregateReactiveRedisProperties")
    public static class AggregateRedisReactiveProperties
    extends RedisReactiveProperties {
    }
}

