/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.config.SchedConfig;
import com.fizzgate.stats.FlowStat;
import com.fizzgate.stats.ResourceTimeWindowStat;
import com.fizzgate.stats.TimeWindowStat;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.NetworkUtils;
import com.fizzgate.util.ResourceIdUtils;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.CollectionUtils;

@Configuration
public class FizzGatewayNodeStatSchedConfig
extends SchedConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FizzGatewayNodeStatSchedConfig.class);
    private static final String fizz_gateway_nodes = "fizz_gateway_nodes";
    @Resource
    private ReactiveWebServerApplicationContext applicationContext;
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    @Value(value="${flowControl:false}")
    private boolean flowControl;
    @Autowired(required=false)
    private FlowStat flowStat;
    @Value(value="${izz-gateway-node-stat-sched.recent:1}")
    private int recent;
    private Stat stat = new Stat();
    private String hashKey;

    @PostConstruct
    public void postConstruct() {
        ConfigurableEnvironment env = this.applicationContext.getEnvironment();
        this.stat.serviceName = env.getProperty("spring.application.name");
        this.stat.ip = NetworkUtils.getServerIp();
        this.stat.port = Integer.parseInt(env.getProperty("server.port", "8600"));
        this.hashKey = this.stat.ip + ':' + this.stat.port;
        this.stat.startTs = ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    @Scheduled(cron="${fizz-gateway-node-stat-sched.cron:*/1 * * * * ?}")
    public void sched() {
        String s;
        this.stat.ts = System.currentTimeMillis();
        if (this.flowControl) {
            TimeWindowStat timeWindowStat;
            BigDecimal rps;
            this.stat.rps = 0.0;
            long currentTimeSlot = this.flowStat.currentTimeSlotId();
            long startTimeSlot = currentTimeSlot - (long)(this.recent * 1000);
            List<ResourceTimeWindowStat> resourceTimeWindowStats = this.flowStat.getResourceTimeWindowStats(ResourceIdUtils.NODE_RESOURCE, startTimeSlot, currentTimeSlot, this.recent);
            if (!CollectionUtils.isEmpty(resourceTimeWindowStats) && (rps = (timeWindowStat = resourceTimeWindowStats.get(0).getWindows().get(0)).getRps()) != null) {
                this.stat.rps = rps.doubleValue();
            }
            this.stat.concurrents = this.flowStat.getConcurrentRequests(ResourceIdUtils.NODE_RESOURCE);
        }
        try {
            s = JacksonUtils.writeValueAsString((Object)this.stat);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("gateway stat: {}", (Object)s);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("serial fizz gateway node stat error", (Throwable)e);
            return;
        }
        this.rt.opsForHash().put((Object)fizz_gateway_nodes, (Object)this.hashKey, (Object)s).doOnError(t -> LOGGER.error("report fizz gateway node stat error", t)).block();
    }

    private static final class Stat {
        public String serviceName;
        public String ip;
        public int port;
        public long ts;
        public long startTs;
        public long concurrents;
        public double rps;

        private Stat() {
        }
    }
}

