/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.util.Result;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.publisher.Mono;

@Configuration
public class FizzMangerConfig {
    private static final Logger log = LoggerFactory.getLogger(FizzMangerConfig.class);
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    public String managerUrl;
    public String pairPath = "/fizz-manager/dedicated-line/pair";
    public String docPathPrefix = "/fizz-manager/open-doc/open-doc-show/pair";

    @PostConstruct
    public void init() throws Throwable {
        Result<?> result = this.updateMangerUrl();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
    }

    public Result<?> updateMangerUrl() {
        Result result = Result.succ();
        this.rt.opsForValue().get((Object)"fizz_manager_url").defaultIfEmpty((Object)"").flatMap(url -> {
            if (url.equals("")) {
                log.warn("no fizz manager url config");
            } else {
                this.managerUrl = url;
                log.info("fizz manager url: {}", (Object)this.managerUrl);
            }
            return Mono.empty();
        }).onErrorReturn(throwable -> {
            result.code = 0;
            result.msg = "update fizz manager url error";
            result.t = throwable;
            log.error(result.msg, result.t);
            return true;
        }, (Object)result).block();
        return result;
    }
}

