/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.config.FlowStatSchedConfigProperties;
import com.fizzgate.config.SchedConfig;
import com.fizzgate.stats.FlowStat;
import com.fizzgate.stats.ResourceTimeWindowStat;
import com.fizzgate.stats.TimeWindowStat;
import com.fizzgate.stats.ratelimit.ResourceRateLimitConfig;
import com.fizzgate.stats.ratelimit.ResourceRateLimitConfigService;
import com.fizzgate.util.DateTimeUtils;
import com.fizzgate.util.NetworkUtils;
import com.fizzgate.util.ResourceIdUtils;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class FlowStatSchedConfig
extends SchedConfig {
    private static final Logger log = LoggerFactory.getLogger(FlowStatSchedConfig.class);
    private static final Logger FLOW_LOGGER = LoggerFactory.getLogger((String)"flow");
    private static final String _ip = "\"ip\":";
    private static final String _id = "\"id\":";
    private static final String _resource = "\"resource\":";
    private static final String _type = "\"type\":";
    private static final String _start = "\"start\":";
    private static final String _reqs = "\"reqs\":";
    private static final String _completeReqs = "\"completeReqs\":";
    private static final String _peakConcurrents = "\"peakConcurrents\":";
    private static final String _reqPerSec = "\"reqPerSec\":";
    private static final String _blockReqs = "\"blockReqs\":";
    private static final String _totalBlockReqs = "\"totalBlockReqs\":";
    private static final String _errors = "\"errors\":";
    private static final String _avgRespTime = "\"avgRespTime\":";
    private static final String _minRespTime = "\"minRespTime\":";
    private static final String _maxRespTime = "\"maxRespTime\":";
    private static final String _app = "\"app\":";
    private static final String _sourceIp = "\"sourceIp\":";
    private static final String _service = "\"service\":";
    private static final String _path = "\"path\":";
    private static final String _peakRps = "\"peakRps\":";
    private static final String _2xxStatus = "\"status2xxs\":";
    private static final String _4xxStatus = "\"status4xxs\":";
    private static final String _5xxStatus = "\"status5xxs\":";
    private static final String _504Status = "\"status504s\":";
    private static final String parentResourceList = "$prl";
    @Resource
    private FlowStatSchedConfigProperties flowStatSchedConfigProperties;
    @Autowired(required=false)
    private FlowStat flowStat;
    @Resource
    private ResourceRateLimitConfigService resourceRateLimitConfigService;
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    private final String ip = NetworkUtils.getServerIp();
    private long startTimeSlot = 0L;

    @Scheduled(cron="${flow-stat-sched.cron}")
    public void sched() {
        if (!this.flowStatSchedConfigProperties.isFlowControl()) {
            return;
        }
        if (this.startTimeSlot == 0L) {
            this.startTimeSlot = this.getRecentEndTimeSlot(this.flowStat);
            return;
        }
        long st = System.currentTimeMillis();
        long recentEndTimeSlot = this.getRecentEndTimeSlot(this.flowStat);
        List<ResourceTimeWindowStat> resourceTimeWindowStats = this.flowStat.getResourceTimeWindowStats(null, this.startTimeSlot, recentEndTimeSlot, 10L);
        if (resourceTimeWindowStats == null || resourceTimeWindowStats.isEmpty()) {
            log.info(this.toDP19(this.startTimeSlot) + " - " + this.toDP19(recentEndTimeSlot) + " no flow stat data");
            return;
        }
        resourceTimeWindowStats.forEach(rtws -> {
            String resource = rtws.getResourceId();
            String app = null;
            String pi = null;
            String node = "_global";
            String service = null;
            String path = null;
            int type = 1;
            int id = 0;
            ResourceRateLimitConfig c = this.resourceRateLimitConfigService.getResourceRateLimitConfig(resource);
            if (c == null) {
                node = ResourceIdUtils.getNode(resource);
                if (node != null) {
                    if (!node.equals("_global")) {
                        type = 8;
                    }
                } else {
                    ResourceRateLimitConfig appConfig;
                    service = ResourceIdUtils.getService(resource);
                    app = ResourceIdUtils.getApp(resource);
                    pi = ResourceIdUtils.getIp(resource);
                    type = service == null ? (app == null ? 7 : ((appConfig = this.resourceRateLimitConfigService.getResourceRateLimitConfig(ResourceIdUtils.APP_DEFAULT_RESOURCE)) != null && appConfig.isEnable() ? 5 : 6)) : (app == null && pi == null ? 2 : (app == null ? 7 : 6));
                }
            } else {
                app = c.app;
                pi = c.ip;
                service = c.service;
                path = c.path;
                type = c.type;
                id = c.id;
            }
            List<TimeWindowStat> wins = rtws.getWindows();
            for (int i = 0; i < wins.size(); ++i) {
                TimeWindowStat w = wins.get(i);
                StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
                long timeWin = w.getStartTime();
                BigDecimal rps = w.getRps();
                BigDecimal peakRps = w.getPeakRps();
                double qps = rps == null ? 0.0 : rps.doubleValue();
                double pRps = peakRps == null ? 0.0 : peakRps.doubleValue();
                long tbrs = w.getTotalBlockRequests();
                b.append('{');
                b.append(_ip);
                FlowStatSchedConfig.toJsonStringValue(b, this.ip);
                b.append(',');
                b.append(_id);
                b.append(id);
                b.append(',');
                String r = null;
                if (type == 1 || type == 8) {
                    r = node;
                } else if (type == 2 || type == 3) {
                    r = service;
                }
                if (r != null) {
                    b.append(_resource);
                    FlowStatSchedConfig.toJsonStringValue(b, r);
                    b.append(',');
                }
                b.append(_type);
                b.append(type);
                b.append(',');
                if (app != null) {
                    b.append(_app);
                    FlowStatSchedConfig.toJsonStringValue(b, app);
                    b.append(',');
                }
                if (pi != null) {
                    b.append(_sourceIp);
                    FlowStatSchedConfig.toJsonStringValue(b, pi);
                    b.append(',');
                }
                if (service != null) {
                    b.append(_service);
                    FlowStatSchedConfig.toJsonStringValue(b, service);
                    b.append(',');
                }
                if (path != null) {
                    b.append(_path);
                    FlowStatSchedConfig.toJsonStringValue(b, path);
                    b.append(',');
                }
                b.append(_start);
                b.append(timeWin);
                b.append(',');
                b.append(_reqs);
                b.append(w.getTotal());
                b.append(',');
                b.append(_completeReqs);
                b.append(w.getCompReqs());
                b.append(',');
                b.append(_peakConcurrents);
                b.append(w.getPeakConcurrentReqeusts());
                b.append(',');
                b.append(_reqPerSec);
                b.append(qps);
                b.append(',');
                b.append(_peakRps);
                b.append(pRps);
                b.append(',');
                b.append(_blockReqs);
                b.append(w.getBlockRequests());
                b.append(',');
                b.append(_totalBlockReqs);
                b.append(tbrs);
                b.append(',');
                b.append(_errors);
                b.append(w.getErrors());
                b.append(',');
                b.append(_avgRespTime);
                b.append(w.getAvgRt());
                b.append(',');
                b.append(_maxRespTime);
                b.append(w.getMax());
                b.append(',');
                b.append(_minRespTime);
                b.append(w.getMin());
                b.append(',');
                b.append(_2xxStatus);
                b.append(w.get2xxStatus());
                b.append(',');
                b.append(_4xxStatus);
                b.append(w.get4xxStatus());
                b.append(',');
                b.append(_5xxStatus);
                b.append(w.get5xxStatus());
                b.append(',');
                b.append(_504Status);
                b.append(w.get504Status());
                b.append('}');
                String msg = b.toString();
                if ("kafka".equals(this.flowStatSchedConfigProperties.getDest())) {
                    FLOW_LOGGER.info(msg);
                } else {
                    this.rt.convertAndSend(this.flowStatSchedConfigProperties.getQueue(), (Object)msg).subscribe();
                }
                if (!log.isDebugEnabled()) continue;
                String wt = 'w' + this.toDP19(timeWin);
                ThreadContext.put((String)"traceId", (String)wt);
                log.debug("report " + wt + ": " + msg);
            }
        });
        this.startTimeSlot = recentEndTimeSlot;
        if (log.isInfoEnabled()) {
            log.info(this.toDP23(st) + " fss " + this.toDP23(System.currentTimeMillis()));
        }
    }

    private long getRecentEndTimeSlot(FlowStat flowStat) {
        long currentTimeSlot = flowStat.currentTimeSlotId();
        int second = DateTimeUtils.transform((long)currentTimeSlot).getSecond();
        long interval = second > 49 ? (long)(second - 50) : (second > 39 ? (long)(second - 40) : (second > 29 ? (long)(second - 30) : (second > 19 ? (long)(second - 20) : (second > 9 ? (long)(second - 10) : (second > 0 ? (long)(second - 0) : 0L)))));
        return currentTimeSlot - interval * 1000L - 10000L;
    }

    private String toDP19(long startTimeSlot) {
        return DateTimeUtils.convert((long)startTimeSlot, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private String toDP23(long startTimeSlot) {
        return DateTimeUtils.convert((long)startTimeSlot, (String)"yyyy-MM-dd HH:mm:ss.SSS");
    }

    private static void toJsonStringValue(StringBuilder b, String value) {
        b.append('\"').append(value).append('\"');
    }
}

