/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.plugin.auth.ApiConfig;
import com.fizzgate.plugin.auth.ApiConfigService;
import com.fizzgate.plugin.auth.GatewayGroupService;
import com.fizzgate.plugin.auth.ServiceConfig;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManualApiConfig {
    protected static final Logger log = LoggerFactory.getLogger(ManualApiConfig.class);
    @Resource
    private GatewayGroupService gatewayGroupService;
    @Resource
    private ApiConfigService apiConfigService;

    public abstract List<ApiConfig> setApiConfigs();

    @PostConstruct
    public void iniApiConfigs() {
        this.gatewayGroupService.currentGatewayGroupSet.add("default");
        List<ApiConfig> apiConfigs = this.setApiConfigs();
        for (ApiConfig ac : apiConfigs) {
            ServiceConfig sc = this.apiConfigService.serviceConfigMap.get(ac.service);
            if (sc == null) {
                sc = new ServiceConfig(ac.service);
                this.apiConfigService.serviceConfigMap.put(ac.service, sc);
            }
            sc.add(ac);
            log.info("manual add {}", (Object)ac);
        }
    }
}

