/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.config.FizzMangerConfig;
import com.fizzgate.config.RefreshLocalCacheConfigProperties;
import com.fizzgate.fizz.ConfigLoader;
import com.fizzgate.plugin.auth.ApiConfig2appsService;
import com.fizzgate.plugin.auth.ApiConfigService;
import com.fizzgate.plugin.auth.AppService;
import com.fizzgate.plugin.auth.GatewayGroupService;
import com.fizzgate.proxy.RpcInstanceService;
import com.fizzgate.service_registry.RegistryCenterService;
import com.fizzgate.stats.ratelimit.ResourceRateLimitConfigService;
import com.fizzgate.util.Result;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class RefreshLocalCacheConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshLocalCacheConfig.class);
    @Resource
    private RefreshLocalCacheConfigProperties refreshLocalCacheConfigProperties;
    @Resource
    private ConfigLoader configLoader;
    @Resource
    private ApiConfigService apiConfigService;
    @Resource
    private ApiConfig2appsService apiConfig2AppsService;
    @Resource
    private GatewayGroupService gatewayGroupService;
    @Resource
    private AppService appService;
    @Resource
    private ResourceRateLimitConfigService resourceRateLimitConfigService;
    @Resource
    private RpcInstanceService rpcInstanceService;
    @Resource
    private FizzMangerConfig fizzMangerConfig;
    @Resource
    private RegistryCenterService registryCenterService;

    @Scheduled(initialDelayString="${refresh-local-cache.initial-delay-millis:300000}", fixedRateString="${refresh-local-cache.fixed-rate-millis:300000}")
    public void refreshLocalCache() {
        if (this.refreshLocalCacheConfigProperties.isApiConfigCacheRefreshEnabled()) {
            LOGGER.debug("refresh api config local cache");
            try {
                this.apiConfigService.refreshLocalCache();
            }
            catch (Throwable t) {
                LOGGER.warn("refresh api config local cache exception", t);
            }
        }
        if (this.refreshLocalCacheConfigProperties.isApiConfig2AppsCacheRefreshEnabled()) {
            LOGGER.debug("refresh api config to apps local cache");
            try {
                this.apiConfig2AppsService.refreshLocalCache();
            }
            catch (Throwable t) {
                LOGGER.warn("refresh api config to apps local cache exception", t);
            }
        }
        if (this.refreshLocalCacheConfigProperties.isAggregateConfigCacheRefreshEnabled()) {
            LOGGER.debug("refresh aggregate config local cache");
            try {
                this.configLoader.refreshLocalCache();
            }
            catch (Exception e) {
                LOGGER.warn("refresh aggregate config local cache exception", (Throwable)e);
            }
        }
        if (this.refreshLocalCacheConfigProperties.isGatewayGroupCacheRefreshEnabled()) {
            LOGGER.debug("refresh gateway group local cache");
            try {
                this.gatewayGroupService.refreshLocalCache();
            }
            catch (Throwable t) {
                LOGGER.warn("refresh gateway group local cache exception", t);
            }
        }
        if (this.refreshLocalCacheConfigProperties.isAppAuthCacheRefreshEnabled()) {
            LOGGER.debug("refresh app auth local cache");
            try {
                this.appService.refreshLocalCache();
            }
            catch (Throwable t) {
                LOGGER.warn("refresh app auth local cache exception", t);
            }
        }
        if (this.refreshLocalCacheConfigProperties.isFlowControlRuleCacheRefreshEnabled()) {
            LOGGER.debug("refresh flow control rule local cache");
            try {
                this.resourceRateLimitConfigService.refreshLocalCache();
            }
            catch (Throwable t) {
                LOGGER.warn("refresh flow control rule local cache exception", t);
            }
        }
        if (this.refreshLocalCacheConfigProperties.isRpcServiceCacheRefreshEnabled()) {
            LOGGER.debug("refresh rpc service local cache");
            try {
                this.rpcInstanceService.refreshLocalCache();
            }
            catch (Throwable t) {
                LOGGER.warn("refresh rpc service local cache exception", t);
            }
        }
        if (this.refreshLocalCacheConfigProperties.isRegistryCenterCacheRefreshEnabled()) {
            Result<?> result = this.registryCenterService.initRegistryCenter();
            if (result.code == 1) {
                LOGGER.info("refresh registry center local cache done");
            } else {
                LOGGER.warn("fail to refresh registry center local cache: {}", (Object)result.msg, (Object)result.t);
            }
        }
        this.fizzMangerConfig.updateMangerUrl();
    }
}

