/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.context.config.annotation.FizzRefreshScope;
import com.fizzgate.util.UUIDUtil;
import com.fizzgate.util.WebUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@FizzRefreshScope
@Component
public class SystemConfig {
    private static final Logger log = LoggerFactory.getLogger(SystemConfig.class);
    public static final String DEFAULT_GATEWAY_PREFIX = "/";
    public static final String DEFAULT_GATEWAY_TEST_PREFIX = "/_proxytest";
    public static final String DEFAULT_GATEWAY_TEST = "_proxytest";
    public static final String DEFAULT_GATEWAY_TEST_PREFIX0 = "/_proxytest/";
    public static boolean FIZZ_ERR_RESP_HTTP_STATUS_ENABLE = true;
    public static String FIZZ_ERR_RESP_CODE_FIELD = "msgCode";
    public static String FIZZ_ERR_RESP_MSG_FIELD = "message";
    public static final String FIZZ_DL_ID = "fizz-dl-id";
    public static final String FIZZ_DL_SIGN = "fizz-dl-sign";
    public static final String FIZZ_DL_TS = "fizz-dl-ts";
    public static final String FIZZ_DL_CLIENT = "fizz-dl-client";
    public static final String FIZZ_APP_ID = "fizz-appid";
    public static final String FIZZ_SIGN = "fizz-sign";
    public static final String FIZZ_TIMESTAMP = "fizz-ts";
    public static final String FIZZ_DEDICATED_LINE_SERVER_ENABLE = "fizz.dedicated-line.server.enable";
    public static final String FIZZ_DEDICATED_LINE_CLIENT_PREFIX = "fizz.dedicated-line.client";
    public static final String FIZZ_DEDICATED_LINE_CLIENT_ENABLE = "fizz.dedicated-line.client.enable";
    private String gatewayPrefix = "/";
    private List<String> appHeaders = Stream.of("fizz-appid").collect(Collectors.toList());
    private List<String> signHeaders = Stream.of("fizz-sign").collect(Collectors.toList());
    private List<String> timestampHeaders = Stream.of("fizz-ts").collect(Collectors.toList());
    private List<String> proxySetHeaders = new ArrayList<String>();
    private boolean aggregateTestAuth = false;
    @Value(value="${fizz.md5sign-timestamp-timeliness:300}")
    private int fizzMD5signTimestampTimeliness = 300;
    @Value(value="${route-timeout:0}")
    private long routeTimeout = 0L;
    @Value(value="${fizz-trace-id.header:X-Trace-Id}")
    private String fizzTraceIdHeader;
    @Value(value="${fizz-trace-id.value-strategy:requestId}")
    private String fizzTraceIdValueStrategy;
    @Value(value="${fizz-trace-id.value-prefix:fizz}")
    private String fizzTraceIdValuePrefix;
    @Value(value="${fizz.dedicated-line.client.request.timeliness:300}")
    private int fizzDedicatedLineClientRequestTimeliness = 300;
    @Value(value="${fizz.dedicated-line.client.request.timeout:0}")
    private int fizzDedicatedLineClientRequestTimeout = 0;
    @Value(value="${fizz.dedicated-line.client.request.retry-count:0}")
    private int fizzDedicatedLineClientRequestRetryCount = 0;
    @Value(value="${fizz.dedicated-line.client.request.retry-interval:0}")
    private int fizzDedicatedLineClientRequestRetryInterval = 0;
    @Value(value="${fizz.dedicated-line.client.request.crypto:true}")
    private boolean fizzDedicatedLineClientRequestCrypto;
    private String fizzDedicatedLineClientId;
    @Value(value="${fizz.fast-fail-when-registry-center-down:false}")
    private boolean fastFailWhenRegistryCenterDown;
    @Value(value="${fizz.web-client.x-forwarded-for.enable:true}")
    private boolean fizzWebClientXForwardedForEnable;
    @Value(value="${fizz.web-client.x-forwarded-for.append-gateway-ip:true}")
    private boolean fizzWebClientXForwardedForAppendGatewayIp;
    private boolean logResponseBody;
    private String logHeaders;
    private Set<String> logHeaderSet = new HashSet<String>();
    @Value(value="${spring.profiles.active}")
    private String profile;

    public int fizzMD5signTimestampTimeliness() {
        return this.fizzMD5signTimestampTimeliness;
    }

    @Value(value="${fizz.error.response.http-status.enable:true}")
    public void setFizzErrRespHttpStatusEnable(boolean fizzErrRespHttpStatusEnable) {
        FIZZ_ERR_RESP_HTTP_STATUS_ENABLE = fizzErrRespHttpStatusEnable;
    }

    @Value(value="${fizz.error.response.code-field:msgCode}")
    public void setFizzErrRespCodeField(String fizzErrRespCodeField) {
        FIZZ_ERR_RESP_CODE_FIELD = fizzErrRespCodeField;
    }

    @Value(value="${fizz.error.response.message-field:message}")
    public void setFizzErrRespMsgField(String fizzErrRespMsgField) {
        FIZZ_ERR_RESP_MSG_FIELD = fizzErrRespMsgField;
    }

    public boolean isFizzWebClientXForwardedForAppendGatewayIp() {
        return this.fizzWebClientXForwardedForAppendGatewayIp;
    }

    public boolean isFizzWebClientXForwardedForEnable() {
        return this.fizzWebClientXForwardedForEnable;
    }

    public boolean isFastFailWhenRegistryCenterDown() {
        return this.fastFailWhenRegistryCenterDown;
    }

    public int fizzDedicatedLineClientRequestTimeout() {
        return this.fizzDedicatedLineClientRequestTimeout;
    }

    public int fizzDedicatedLineClientRequestRetryCount() {
        return this.fizzDedicatedLineClientRequestRetryCount;
    }

    public int fizzDedicatedLineClientRequestRetryInterval() {
        return this.fizzDedicatedLineClientRequestRetryInterval;
    }

    public int fizzDedicatedLineClientRequestTimeliness() {
        return this.fizzDedicatedLineClientRequestTimeliness;
    }

    public boolean fizzDedicatedLineClientRequestCrypto() {
        return this.fizzDedicatedLineClientRequestCrypto;
    }

    @Value(value="${fizz.dedicated-line.client.id:}")
    public void setFizzDedicatedLineClientId(String id) {
        this.fizzDedicatedLineClientId = StringUtils.isBlank((CharSequence)id) ? UUIDUtil.getUUID() : id;
        log.info("fizz dedicated line client id: {}", (Object)this.fizzDedicatedLineClientId);
    }

    public String fizzDedicatedLineClientId() {
        return this.fizzDedicatedLineClientId;
    }

    public String fizzTraceIdHeader() {
        return this.fizzTraceIdHeader;
    }

    public String fizzTraceIdValueStrategy() {
        return this.fizzTraceIdValueStrategy;
    }

    public String fizzTraceIdValuePrefix() {
        return this.fizzTraceIdValuePrefix;
    }

    public long getRouteTimeout() {
        return this.routeTimeout;
    }

    @Value(value="${gateway.aggr.proxy_set_headers:}")
    public void setProxySetHeaders(String hdrs) {
        if (StringUtils.isNotBlank((CharSequence)hdrs)) {
            this.proxySetHeaders.clear();
            for (String h : StringUtils.split((String)hdrs, (char)',')) {
                this.proxySetHeaders.add(h.trim());
            }
        }
        log.info("proxy set headers: " + hdrs);
    }

    public List<String> getProxySetHeaders() {
        return this.proxySetHeaders;
    }

    @Value(value="${gateway.prefix:/}")
    public void setGatewayPrefix(String gp) {
        this.gatewayPrefix = gp;
        WebUtils.setGatewayPrefix(this.gatewayPrefix);
        log.info("gateway prefix: " + this.gatewayPrefix);
    }

    public String getGatewayPrefix() {
        return this.gatewayPrefix;
    }

    @Value(value="${custom.header.appid:}")
    public void setCustomAppHeaders(String hdrs) {
        if (StringUtils.isNotBlank((CharSequence)hdrs)) {
            this.appHeaders.clear();
            this.appHeaders.add(FIZZ_APP_ID);
            for (String h : StringUtils.split((String)hdrs, (char)',')) {
                String trim = h.trim();
                if (trim.equals(FIZZ_APP_ID)) continue;
                this.appHeaders.add(trim);
            }
        }
        WebUtils.setAppHeaders(this.appHeaders);
        log.info("app headers: " + this.appHeaders);
    }

    @Value(value="${custom.header.sign:}")
    public void setCustomSignHeaders(String hdrs) {
        if (StringUtils.isNotBlank((CharSequence)hdrs)) {
            this.signHeaders.clear();
            this.signHeaders.add(FIZZ_SIGN);
            for (String h : StringUtils.split((String)hdrs, (char)',')) {
                String trim = h.trim();
                if (trim.equals(FIZZ_SIGN)) continue;
                this.signHeaders.add(trim);
            }
        }
        WebUtils.setSignHeaders(this.signHeaders);
        log.info("sign headers: " + this.signHeaders);
    }

    @Value(value="${custom.header.ts:}")
    public void setCustomTimestampHeaders(String hdrs) {
        if (StringUtils.isNotBlank((CharSequence)hdrs)) {
            this.timestampHeaders.clear();
            this.timestampHeaders.add(FIZZ_TIMESTAMP);
            for (String h : StringUtils.split((String)hdrs, (char)',')) {
                String trim = h.trim();
                if (trim.equals(FIZZ_TIMESTAMP)) continue;
                this.timestampHeaders.add(trim);
            }
        }
        WebUtils.setTimestampHeaders(this.timestampHeaders);
        log.info("timestamp headers: " + this.timestampHeaders);
    }

    @Value(value="${aggregate-test-auth:false}")
    public void setAggregateTestAuth(boolean b) {
        this.aggregateTestAuth = b;
        log.info("aggregate test auth: " + this.aggregateTestAuth);
    }

    public boolean isAggregateTestAuth() {
        return this.aggregateTestAuth;
    }

    public String getProfile() {
        return this.profile;
    }

    public Set<String> getLogHeaderSet() {
        return this.logHeaderSet;
    }

    @PostConstruct
    public void afterPropertiesSet() {
    }

    private void afterLogResponseBodySet() {
        WebUtils.LOG_RESPONSE_BODY = this.logResponseBody;
        log.info("log response body: " + this.logResponseBody);
    }

    private void afterLogHeadersSet() {
        this.logHeaderSet.clear();
        Arrays.stream(StringUtils.split((String)this.logHeaders, (char)',')).forEach(h -> this.logHeaderSet.add((String)h));
        if (!this.fizzTraceIdHeader.equals("X-Trace-Id")) {
            this.logHeaderSet.add(this.fizzTraceIdHeader);
        }
        WebUtils.LOG_HEADER_SET = this.logHeaderSet;
        log.info("log headers: " + this.logHeaderSet.toString());
    }

    private void updateLogResponseBody(boolean newValue) {
        this.logResponseBody = newValue;
        this.afterLogResponseBodySet();
    }

    private void updateLogHeaders(String newValue) {
        this.logHeaders = newValue;
        this.afterLogHeadersSet();
    }

    @Value(value="${log.response-body:false}")
    public void setLogResponseBody(boolean logResponseBody) {
        if (this.logResponseBody == logResponseBody) {
            return;
        }
        log.info("log.response-body old: " + this.logResponseBody + ", new: " + logResponseBody);
        this.updateLogResponseBody(logResponseBody);
    }

    @Value(value="${log.headers:}")
    public void setLogHeaders(String logHeaders) {
        if (ObjectUtils.nullSafeEquals((Object)this.logHeaders, (Object)logHeaders)) {
            return;
        }
        log.info("log.headers old: " + this.logHeaders + ", new: " + logHeaders);
        this.updateLogHeaders(logHeaders);
    }
}

