/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.config;

import com.fizzgate.config.WebServerConfigProperties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import org.springframework.http.codec.multipart.SynchronossPartHttpMessageReader;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;

@Configuration
@ConfigurationProperties(prefix="server")
@EnableConfigurationProperties(value={ServerProperties.class})
public class WebServerConfig {
    private static final Logger log = LoggerFactory.getLogger(WebServerConfig.class);

    @Configuration
    @EnableWebFlux
    public static class FizzWebFluxConfigurer
    implements WebFluxConfigurer {
        @Resource
        private WebServerConfigProperties webServerConfigProperties;

        public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
            ServerCodecConfigurer.ServerDefaultCodecs serverDefaultCodecs = configurer.defaultCodecs();
            serverDefaultCodecs.maxInMemorySize(-1);
            SynchronossPartHttpMessageReader partReader = new SynchronossPartHttpMessageReader();
            partReader.setMaxParts(this.webServerConfigProperties.getMaxParts());
            partReader.setMaxDiskUsagePerPart(this.webServerConfigProperties.getMaxDiskUsagePerPart());
            MultipartHttpMessageReader multipartReader = new MultipartHttpMessageReader((HttpMessageReader)partReader);
            serverDefaultCodecs.multipartReader((HttpMessageReader)multipartReader);
        }

        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/*.*"}).addResourceLocations(new String[]{"classpath:/static/"});
        }
    }
}

