/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.context.event;

import com.fizzgate.beans.factory.config.FizzBeanFactoryPostProcessor;
import com.fizzgate.context.event.FizzRefreshEvent;
import com.fizzgate.context.scope.refresh.FizzRefreshScope;
import com.fizzgate.util.JacksonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

public class FizzRefreshEventListener
implements SmartApplicationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FizzRefreshEventListener.class);
    private final FizzBeanFactoryPostProcessor fizzBeanFactoryPostProcessor;
    private final FizzRefreshScope fizzRefreshScope;
    private final AtomicBoolean ready = new AtomicBoolean(false);

    public FizzRefreshEventListener(FizzBeanFactoryPostProcessor fizzBeanFactoryPostProcessor, FizzRefreshScope fizzRefreshScope) {
        this.fizzBeanFactoryPostProcessor = fizzBeanFactoryPostProcessor;
        this.fizzRefreshScope = fizzRefreshScope;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationReadyEvent.class.isAssignableFrom(eventType) || FizzRefreshEvent.class.isAssignableFrom(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            this.handle((ApplicationReadyEvent)event);
        } else if (event instanceof FizzRefreshEvent) {
            this.handle((FizzRefreshEvent)event);
        }
    }

    public void handle(ApplicationReadyEvent event) {
        this.ready.compareAndSet(false, true);
    }

    public void handle(FizzRefreshEvent event) {
        if (this.ready.get() && event.getType() == 1) {
            HashMap<String, Map> bean2propertyValuesMap = new HashMap<String, Map>();
            Map changedPropertyValueMap = (Map)event.getData();
            changedPropertyValueMap.forEach((property, value) -> {
                String bean = this.fizzBeanFactoryPostProcessor.getBean((String)property);
                if (bean != null) {
                    Map propertyValueMap = bean2propertyValuesMap.computeIfAbsent(bean, k -> new HashMap());
                    propertyValueMap.put(property, value);
                }
            });
            bean2propertyValuesMap.forEach((bean, propertyValueMap) -> {
                this.fizzRefreshScope.refresh((String)bean);
                LOGGER.info("fizz refresh {} bean with {}", bean, (Object)JacksonUtils.writeValueAsString((Object)propertyValueMap));
            });
        }
    }
}

