/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.context.scope.refresh;

import com.fizzgate.context.scope.refresh.FizzRefreshScopeRefreshedEvent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.context.scope.GenericScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class FizzRefreshScope
extends GenericScope
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private ApplicationContext context;
    private BeanDefinitionRegistry registry;
    private boolean eager = true;
    private int order = 2147483547;

    public FizzRefreshScope() {
        super.setName("FizzRefresh");
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setEager(boolean eager) {
        this.eager = eager;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
        super.postProcessBeanDefinitionRegistry(registry);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.start(event);
    }

    public void start(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.context && this.eager && this.registry != null) {
            this.eagerlyInitialize();
        }
    }

    private void eagerlyInitialize() {
        for (String name : this.context.getBeanDefinitionNames()) {
            Object bean;
            BeanDefinition definition = this.registry.getBeanDefinition(name);
            if (!this.getName().equals(definition.getScope()) || definition.isLazyInit() || (bean = this.context.getBean(name)) == null) continue;
            bean.getClass();
        }
    }

    @ManagedOperation(description="Dispose of the current instance of bean name provided and force a refresh on next method execution.")
    public boolean refresh(String name) {
        if (!name.startsWith("scopedTarget.")) {
            name = "scopedTarget." + name;
        }
        if (super.destroy(name)) {
            this.context.publishEvent((ApplicationEvent)new FizzRefreshScopeRefreshedEvent(name));
            return true;
        }
        return false;
    }

    @ManagedOperation(description="Dispose of the current instance of all beans in this scope and force a refresh on next method execution.")
    public void refreshAll() {
        super.destroy();
        this.context.publishEvent((ApplicationEvent)new FizzRefreshScopeRefreshedEvent());
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }
}

