/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.controller;

import com.fizzgate.global_resource.GlobalResourceService;
import com.fizzgate.plugin.auth.ApiConfig2appsService;
import com.fizzgate.plugin.auth.ApiConfigService;
import com.fizzgate.plugin.auth.AppService;
import com.fizzgate.plugin.auth.GatewayGroupService;
import com.fizzgate.stats.FlowStat;
import com.fizzgate.stats.ResourceStat;
import com.fizzgate.stats.circuitbreaker.CircuitBreakManager;
import com.fizzgate.stats.ratelimit.ResourceRateLimitConfig;
import com.fizzgate.stats.ratelimit.ResourceRateLimitConfigService;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ResourceIdUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import org.openjdk.jol.info.GraphLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/admin/cache"})
public class CacheCheckController {
    @Resource
    private GatewayGroupService gatewayGroupService;
    @Resource
    private AppService appService;
    @Resource
    private ApiConfigService apiConfigService;
    @Resource
    private ResourceRateLimitConfigService resourceRateLimitConfigService;
    @Resource
    private ApiConfig2appsService apiConfig2AppsService;
    @Resource
    private GlobalResourceService globalResourceService;
    @Resource
    private CircuitBreakManager circuitBreakManager;
    @Autowired(required=false)
    private FlowStat flowStat;

    @GetMapping(value={"/gatewayGroups"})
    public Mono<String> gatewayGroups(ServerWebExchange exchange) {
        return Mono.just((Object)JacksonUtils.writeValueAsString(this.gatewayGroupService.gatewayGroupMap));
    }

    @GetMapping(value={"/currentGatewayGroups"})
    public Mono<String> currentGatewayGroups(ServerWebExchange exchange) {
        return Mono.just((Object)JacksonUtils.writeValueAsString(this.gatewayGroupService.currentGatewayGroupSet));
    }

    @GetMapping(value={"/apps"})
    public Mono<String> apps(ServerWebExchange exchange) {
        return Mono.just((Object)JacksonUtils.writeValueAsString(this.appService.getAppMap()));
    }

    @GetMapping(value={"/serviceConfigs"})
    public Mono<String> serviceConfigs(ServerWebExchange exchange) {
        return Mono.just((Object)JacksonUtils.writeValueAsString(this.apiConfigService.serviceConfigMap));
    }

    @GetMapping(value={"/resourceRateLimitConfigs"})
    public Mono<String> resourceRateLimitConfigs(ServerWebExchange exchange) {
        return Mono.just((Object)JacksonUtils.writeValueAsString(this.resourceRateLimitConfigService.getResourceRateLimitConfigMap()));
    }

    @GetMapping(value={"/apiConfig2appsConfigs"})
    public Mono<String> apiConfig2appsConfigs(ServerWebExchange exchange) {
        return Mono.just((Object)JacksonUtils.writeValueAsString(this.apiConfig2AppsService.getApiConfig2appsMap()));
    }

    @GetMapping(value={"/globalResources"})
    public Mono<String> globalResources(ServerWebExchange exchange) {
        return Mono.just((Object)JacksonUtils.writeValueAsString(this.globalResourceService.getResourceMap()));
    }

    @GetMapping(value={"/circuitBreakers"})
    public Mono<String> circuitBreakers(ServerWebExchange exchange) {
        return Mono.just((Object)JacksonUtils.writeValueAsString(this.circuitBreakManager.getResource2circuitBreakerMap()));
    }

    @GetMapping(value={"/resourceStats"})
    public Mono<String> resourceStats(ServerWebExchange exchange) {
        String resourceStatsSize;
        HashMap<String, Object> map = new HashMap<String, Object>();
        int nodeCnt = 0;
        int serviceDefaultCnt = 0;
        int serviceCnt = 0;
        int servicePathCnt = 0;
        int appDefaultCnt = 0;
        int appCnt = 0;
        int ipCnt = 0;
        int hostCnt = 0;
        ConcurrentMap<String, ResourceStat> resourceStats = this.flowStat.resourceStats;
        Set entrySet = resourceStats.entrySet();
        for (Map.Entry entry : entrySet) {
            String resource = (String)entry.getKey();
            ResourceRateLimitConfig config = this.resourceRateLimitConfigService.getResourceRateLimitConfig(resource);
            if (config == null) {
                String app = ResourceIdUtils.getApp(resource);
                String ip = ResourceIdUtils.getIp(resource);
                String node = ResourceIdUtils.getNode(resource);
                String service = ResourceIdUtils.getService(resource);
                if (node == null) {
                    if (app != null) {
                        ResourceRateLimitConfig appConfig = this.resourceRateLimitConfigService.getResourceRateLimitConfig(ResourceIdUtils.APP_DEFAULT_RESOURCE);
                        if (appConfig != null && appConfig.isEnable()) {
                            ++appDefaultCnt;
                            continue;
                        }
                        ++appCnt;
                        continue;
                    }
                    if (ip != null) {
                        ++ipCnt;
                        continue;
                    }
                    if (service == null) continue;
                    ++serviceDefaultCnt;
                    continue;
                }
                if (node.equals("_global")) {
                    ++nodeCnt;
                    continue;
                }
                ++hostCnt;
                continue;
            }
            byte t = config.type;
            if (t == 1) {
                ++nodeCnt;
                continue;
            }
            if (t == 2) {
                ++serviceDefaultCnt;
                continue;
            }
            if (t == 3) {
                ++serviceCnt;
                continue;
            }
            if (t == 5) {
                ++appDefaultCnt;
                continue;
            }
            if (t == 6) {
                ++appCnt;
                continue;
            }
            if (t == 7) {
                ++ipCnt;
                continue;
            }
            if (t == 4) {
                ++servicePathCnt;
                continue;
            }
            ++hostCnt;
        }
        map.put("node", nodeCnt);
        map.put("serviceDefault", serviceDefaultCnt);
        map.put("service", serviceCnt);
        map.put("appDefault", appDefaultCnt);
        map.put("app", appCnt);
        map.put("ip", ipCnt);
        map.put("host", hostCnt);
        map.put("servicePathCnt", servicePathCnt);
        int totalResources = appCnt + appDefaultCnt + ipCnt + nodeCnt + hostCnt + serviceCnt + serviceDefaultCnt + servicePathCnt;
        map.put("totalResources", totalResources);
        long size = GraphLayout.parseInstance((Object[])new Object[]{resourceStats}).totalSize();
        BigDecimal bigDecimalSize = new BigDecimal(size);
        if (size >= 0x40000000L) {
            float r = bigDecimalSize.divide(new BigDecimal(0x40000000), 2, RoundingMode.HALF_UP).floatValue();
            resourceStatsSize = r + " GB";
        } else if (size >= 0x100000L) {
            float r = bigDecimalSize.divide(new BigDecimal(0x100000), 2, RoundingMode.HALF_UP).floatValue();
            resourceStatsSize = r + " MB";
        } else if (size >= 1024L) {
            float r = bigDecimalSize.divide(new BigDecimal(1024), 2, RoundingMode.HALF_UP).floatValue();
            resourceStatsSize = r + " KB";
        } else {
            resourceStatsSize = size + " B";
        }
        map.put("resourceStatsSize", resourceStatsSize);
        return Mono.just((Object)JacksonUtils.writeValueAsString(map));
    }
}

