/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.controller;

import com.fizzgate.proxy.CallbackReplayReq;
import com.fizzgate.proxy.CallbackService;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.Result;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/admin"})
public class CallbackController {
    private static final Logger log = LoggerFactory.getLogger(CallbackController.class);
    @Resource
    private CallbackService callbackService;

    @PostMapping(value={"/callback"})
    public Mono<String> callback(ServerWebExchange exchange, @RequestBody CallbackReplayReq req) {
        if (log.isDebugEnabled()) {
            ThreadContext.put((String)"traceId", (String)req.id);
            log.debug(JacksonUtils.writeValueAsString((Object)req));
        }
        return this.callbackService.replay(req).onErrorResume(t -> Mono.just((Object)Result.fail((Throwable)t))).map(r -> {
            StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
            b.append(req.id).append(' ').append(req.service).append(' ').append(req.path).append(' ');
            ServerHttpResponse resp = exchange.getResponse();
            ThreadContext.put((String)"traceId", (String)req.id);
            if (r.code == 1) {
                log.info(b.append("replay success").toString());
                resp.setStatusCode(HttpStatus.OK);
                return "";
            }
            b.append("replay error:\n").append(r);
            log.error(b.toString());
            resp.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            if (r.msg != null) {
                return r.msg;
            }
            if (r.t != null) {
                return r.t.getMessage();
            }
            return "unknown error";
        });
    }
}

