/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.controller;

import com.fizzgate.stats.FlowStat;
import com.fizzgate.stats.ResourceTimeWindowStat;
import com.fizzgate.stats.TimeWindowStat;
import com.fizzgate.util.DateTimeUtils;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ResourceIdUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RefreshScope
@RestController
@RequestMapping(value={"/admin/flowStat"})
public class FlowControlController {
    private static final Logger log = LoggerFactory.getLogger(FlowControlController.class);
    @Value(value="${flowControl:false}")
    private boolean flowControl;
    @Autowired(required=false)
    private FlowStat flowStat;

    @GetMapping(value={"/globalConcurrentsRps"})
    public Mono<String> globalConcurrentsRps(ServerWebExchange exchange, @RequestParam(value="recent", required=false, defaultValue="3") int recent) {
        long concurrents = 0L;
        double rps = 0.0;
        HashMap<String, Number> result = new HashMap<String, Number>();
        result.put("concurrents", concurrents);
        result.put("rps", rps);
        if (this.flowControl) {
            try {
                long currentTimeSlot = this.flowStat.currentTimeSlotId();
                long startTimeSlot = currentTimeSlot - (long)(recent * 1000);
                TimeWindowStat timeWindowStat = null;
                List<ResourceTimeWindowStat> wins = this.flowStat.getResourceTimeWindowStats(ResourceIdUtils.NODE_RESOURCE, startTimeSlot, currentTimeSlot, recent);
                if (wins == null || wins.isEmpty()) {
                    result.put("rps", 0);
                } else {
                    concurrents = this.flowStat.getConcurrentRequests(ResourceIdUtils.NODE_RESOURCE);
                    result.put("concurrents", concurrents);
                    timeWindowStat = wins.get(0).getWindows().get(0);
                    BigDecimal winrps = timeWindowStat.getRps();
                    rps = winrps == null ? 0.0 : winrps.doubleValue();
                    result.put("rps", rps);
                }
                if (log.isDebugEnabled()) {
                    long compReqs = -1L;
                    if (timeWindowStat != null) {
                        compReqs = timeWindowStat.getCompReqs();
                    }
                    log.debug(this.toDP19(startTimeSlot) + " - " + this.toDP19(currentTimeSlot) + " result: " + JacksonUtils.writeValueAsString(result) + ", complete reqs: " + compReqs);
                }
            }
            catch (Throwable t) {
                log.error("get current global concurrents and rps error", t);
            }
        }
        return Mono.just((Object)JacksonUtils.writeValueAsString(result));
    }

    private String toDP19(long startTimeSlot) {
        return DateTimeUtils.convert((long)startTimeSlot, (String)"yyyy-MM-dd HH:mm:ss");
    }
}

