/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.controller;

import com.fizzgate.controller.req.BaseManagerConfigReq;
import com.fizzgate.controller.req.GetApiConfigDetailReq;
import com.fizzgate.controller.req.GetApiConfigReq;
import com.fizzgate.controller.req.GetConfigReq;
import com.fizzgate.controller.req.GetConfigStrReq;
import com.fizzgate.controller.resp.ApiConfigInfo;
import com.fizzgate.controller.resp.ConfigResp;
import com.fizzgate.controller.resp.ConfigStrResp;
import com.fizzgate.controller.resp.GetApiConfigDetailResp;
import com.fizzgate.controller.resp.GetApiConfigResp;
import com.fizzgate.fizz.ConfigLoader;
import com.fizzgate.plugin.PluginConfig;
import com.fizzgate.plugin.auth.ApiConfig;
import com.fizzgate.plugin.auth.ApiConfig2appsService;
import com.fizzgate.plugin.auth.ApiConfigService;
import com.fizzgate.plugin.auth.GatewayGroup;
import com.fizzgate.plugin.auth.GatewayGroupService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RefreshScope
@RestController
@RequestMapping(value={"/admin/managerConfig"})
public class ManagerConfigController {
    public static final Set<Byte> API_AUTH_PROXY_MODE_SET = Sets.newHashSet((Object[])new Byte[]{(byte)1, (byte)2, (byte)3, (byte)5});
    @Value(value="${fizz.manager.config.key:fizz-manager-key}")
    private String key;
    @Resource
    private ConfigLoader configLoader;
    @Resource
    private ApiConfigService apiConfigService;
    @Resource
    private GatewayGroupService gatewayGroupService;
    @Resource
    private ApiConfig2appsService apiConfig2appsService;

    @PostMapping(value={"/getAggregateConfigs"})
    public Mono<ConfigResp> getAggregateConfigs(@Valid @RequestBody GetConfigReq getConfigReq) {
        this.checkSign(getConfigReq);
        String serviceNameCondition = getConfigReq.getServiceName();
        String pathCondition = getConfigReq.getPath();
        String nameCondition = getConfigReq.getName();
        List<ConfigLoader.ConfigInfo> allConfigInfoList = this.configLoader.getConfigInfo();
        List<ConfigLoader.ConfigInfo> configInfoList = allConfigInfoList.stream().filter(it -> {
            if (StringUtils.hasText((String)serviceNameCondition) && !it.getServiceName().contains(serviceNameCondition)) {
                return Boolean.FALSE;
            }
            if (StringUtils.hasText((String)pathCondition) && !it.getPath().contains(pathCondition)) {
                return Boolean.FALSE;
            }
            if (StringUtils.hasText((String)nameCondition) && !it.getConfigName().contains(nameCondition)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }).collect(Collectors.toList());
        ConfigResp configResp = new ConfigResp();
        configResp.setConfigInfos(configInfoList);
        return Mono.just((Object)configResp);
    }

    @PostMapping(value={"/getConfigStr"})
    public Mono<ConfigStrResp> getConfigStr(@Valid @RequestBody GetConfigStrReq getConfigStrReq) {
        this.checkSign(getConfigStrReq);
        String configId = getConfigStrReq.getConfigId();
        String configStr = this.configLoader.getConfigStr(configId);
        ConfigStrResp configStrResp = new ConfigStrResp();
        configStrResp.setConfigStr(configStr);
        return Mono.just((Object)configStrResp);
    }

    @PostMapping(value={"/getApiConfigs"})
    public Mono<GetApiConfigResp> getApiConfigs(@Valid @RequestBody GetApiConfigReq getApiConfigReq) {
        this.checkSign(getApiConfigReq);
        Integer current = getApiConfigReq.getCurrent();
        Integer size = getApiConfigReq.getSize();
        String gatewayGroup = getApiConfigReq.getGatewayGroup();
        String service = getApiConfigReq.getService();
        String path = getApiConfigReq.getPath();
        Set<String> methods = getApiConfigReq.getMethods();
        Set<String> plugins = getApiConfigReq.getPlugins();
        String access = getApiConfigReq.getAccess();
        Set<String> currentGatewayGroupSet = this.gatewayGroupService.currentGatewayGroupSet;
        List apiConfigInfoList = this.apiConfigService.getApiConfigMap().values().stream().filter(it -> {
            if (!currentGatewayGroupSet.contains(it.firstGatewayGroup)) {
                return false;
            }
            if (!API_AUTH_PROXY_MODE_SET.contains(it.type)) {
                return false;
            }
            if (StringUtils.hasText((String)gatewayGroup) && !it.firstGatewayGroup.equals(gatewayGroup)) {
                return false;
            }
            if (StringUtils.hasText((String)service) && !it.service.contains(service)) {
                return false;
            }
            if (StringUtils.hasText((String)path) && !it.path.contains(path)) {
                return false;
            }
            if (!CollectionUtils.isEmpty((Collection)methods) && !methods.contains(it.fizzMethod instanceof HttpMethod ? ((HttpMethod)it.fizzMethod).name() : it.fizzMethod)) {
                return false;
            }
            if (!CollectionUtils.isEmpty((Collection)plugins)) {
                boolean match = false;
                for (PluginConfig pluginConfig : it.pluginConfigs) {
                    if (!plugins.contains(pluginConfig.plugin)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    GatewayGroup group = this.gatewayGroupService.get(it.firstGatewayGroup);
                    if (group != null) {
                        for (PluginConfig pluginConfig : group.pluginConfigs) {
                            if (!plugins.contains(pluginConfig.plugin)) continue;
                            match = true;
                            break;
                        }
                    }
                    if (!match) {
                        return false;
                    }
                }
            }
            if ("a".equals(access) && !it.allowAccess) {
                return false;
            }
            return !"f".equals(access) || !it.allowAccess;
        }).map(it -> {
            ApiConfigInfo apiConfigInfo = new ApiConfigInfo();
            apiConfigInfo.setId(Long.valueOf(it.id));
            apiConfigInfo.setGatewayGroup(it.firstGatewayGroup);
            apiConfigInfo.setProxyMode(it.type);
            apiConfigInfo.setIsDedicatedLine(it.dedicatedLine ? (byte)1 : (byte)0);
            apiConfigInfo.setService(it.service);
            apiConfigInfo.setPath(it.path);
            apiConfigInfo.setMethod(it.fizzMethod instanceof HttpMethod ? ((HttpMethod)it.fizzMethod).name() : "");
            List<PluginConfig> gatewayGroupPluginConfigs = null;
            GatewayGroup group = this.gatewayGroupService.get(it.firstGatewayGroup);
            if (group != null) {
                gatewayGroupPluginConfigs = group.pluginConfigs;
            }
            if (CollectionUtils.isEmpty(gatewayGroupPluginConfigs)) {
                apiConfigInfo.setPlugins(it.pluginConfigs.stream().map(pluginConfig -> pluginConfig.plugin).collect(Collectors.toList()));
            } else {
                ArrayList<PluginConfig> pcs = new ArrayList<PluginConfig>(gatewayGroupPluginConfigs.size() + it.pluginConfigs.size());
                pcs.addAll(gatewayGroupPluginConfigs);
                pcs.addAll(it.pluginConfigs);
                pcs.sort(null);
                apiConfigInfo.setPlugins(pcs.stream().map(pluginConfig -> pluginConfig.plugin).collect(Collectors.toList()));
            }
            apiConfigInfo.setAccess(it.allowAccess ? "a" : "f");
            return apiConfigInfo;
        }).collect(Collectors.toList());
        GetApiConfigResp getApiConfigResp = new GetApiConfigResp();
        getApiConfigResp.setTotal(Long.valueOf(apiConfigInfoList.size()));
        apiConfigInfoList.sort(Comparator.comparing(ApiConfigInfo::getId).reversed());
        int apiConfigListSize = apiConfigInfoList.size();
        int startIndex = (current - 1) * size;
        if (startIndex >= apiConfigListSize) {
            return Mono.just((Object)getApiConfigResp);
        }
        int endIndex = current * size;
        if (endIndex > apiConfigListSize) {
            endIndex = apiConfigListSize;
        }
        getApiConfigResp.setApiConfigInfos(apiConfigInfoList.subList(startIndex, endIndex));
        return Mono.just((Object)getApiConfigResp);
    }

    @PostMapping(value={"/getApiConfigDetail"})
    public Mono<GetApiConfigDetailResp> getApiConfigDetail(@Valid @RequestBody GetApiConfigDetailReq getApiConfigDetailReq) {
        this.checkSign(getApiConfigDetailReq);
        Long apiConfigId = getApiConfigDetailReq.getApiConfigId();
        ApiConfig apiConfig = this.apiConfigService.getApiConfigMap().get(apiConfigId.intValue());
        GetApiConfigDetailResp getApiConfigDetailResp = new GetApiConfigDetailResp();
        if (apiConfig == null) {
            getApiConfigDetailResp.setExist(false);
        } else {
            getApiConfigDetailResp.setExist(true);
            getApiConfigDetailResp.setId(Long.valueOf(apiConfig.id));
            getApiConfigDetailResp.setGatewayGroup(apiConfig.firstGatewayGroup);
            getApiConfigDetailResp.setService(apiConfig.service);
            getApiConfigDetailResp.setMethod(apiConfig.fizzMethod instanceof HttpMethod ? ((HttpMethod)apiConfig.fizzMethod).name() : "");
            getApiConfigDetailResp.setPath(apiConfig.path);
            getApiConfigDetailResp.setAppEnabled(apiConfig.checkApp);
            if (apiConfig.checkApp) {
                getApiConfigDetailResp.setApps(this.apiConfig2appsService.getApiConfig2appsMap().get(apiConfig.id));
            }
            getApiConfigDetailResp.setAccess(apiConfig.allowAccess ? "a" : "f");
            getApiConfigDetailResp.setProxyMode(apiConfig.type);
            getApiConfigDetailResp.setBackendService(apiConfig.backendService);
            getApiConfigDetailResp.setBackendPath(apiConfig.backendPath);
            getApiConfigDetailResp.setApiPlugins(apiConfig.pluginConfigs.stream().map(pluginConfig -> {
                GetApiConfigDetailResp.ApiPluginVO apiPluginVO = new GetApiConfigDetailResp.ApiPluginVO();
                apiPluginVO.setPlugin(pluginConfig.plugin);
                apiPluginVO.setConfig(pluginConfig.config);
                apiPluginVO.setOrder(pluginConfig.order);
                return apiPluginVO;
            }).collect(Collectors.toList()));
            getApiConfigDetailResp.setApiBackends(apiConfig.httpHostPorts);
            getApiConfigDetailResp.setRpcMethod(apiConfig.rpcMethod);
            getApiConfigDetailResp.setRpcParamTypes(apiConfig.rpcParamTypes);
            getApiConfigDetailResp.setRpcVersion(apiConfig.rpcVersion);
            getApiConfigDetailResp.setRpcGroup(apiConfig.rpcGroup);
            getApiConfigDetailResp.setTimeout((int)apiConfig.timeout);
            getApiConfigDetailResp.setRetryCount(apiConfig.retryCount);
            getApiConfigDetailResp.setRetryInterval(apiConfig.retryInterval);
            getApiConfigDetailResp.setIsDedicatedLine(apiConfig.dedicatedLine ? (byte)1 : 0);
            getApiConfigDetailResp.setRegistryName(apiConfig.registryCenter);
        }
        return Mono.just((Object)getApiConfigDetailResp);
    }

    private void checkSign(BaseManagerConfigReq req) {
        if (!req.checkSign(this.key)) {
            throw new RuntimeException("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
        }
    }
}

