/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.dedicated_line;

import cn.hutool.core.codec.Base64;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fizzgate.dedicated_line.ApiDoc;
import com.fizzgate.dedicated_line.MethodAndPath;
import com.fizzgate.util.JacksonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class DedicatedLine {
    public boolean isDeleted = false;
    public String pairCodeId;
    public String secretKey;
    public String requestCryptoKey;
    public String customConfig;
    public List<ApiDoc> apiDocs = Collections.emptyList();
    @JsonIgnore
    public Map<String, Map<Object, Set<String>>> apiDocMap = Collections.emptyMap();
    public Set<String> servicesWithoutApiDocs = Collections.emptySet();

    public void setDeleted(int v) {
        if (v == 1) {
            this.isDeleted = true;
        }
    }

    public void setSecretKey(String sk) {
        this.secretKey = sk;
        int len = this.secretKey.length() / 2;
        this.requestCryptoKey = this.secretKey.substring(0, len);
        this.requestCryptoKey = Base64.encode((byte[])this.requestCryptoKey.getBytes());
    }

    public void setDocs(List<ApiDoc> docs) {
        this.apiDocs = docs;
        if (CollectionUtils.isEmpty(this.apiDocs)) {
            this.apiDocMap = Collections.emptyMap();
        } else {
            this.apiDocMap = new HashMap<String, Map<Object, Set<String>>>();
            for (ApiDoc apiDoc : this.apiDocs) {
                Map methodPathsMap = this.apiDocMap.computeIfAbsent(apiDoc.service, k -> new HashMap());
                for (MethodAndPath methodAndPath : apiDoc.methodAndPaths) {
                    Set paths = methodPathsMap.computeIfAbsent(methodAndPath.method, k -> new HashSet());
                    paths.add(methodAndPath.path);
                }
            }
        }
    }

    public void setServices(Set<String> services) {
        this.servicesWithoutApiDocs = services;
    }

    public String toString() {
        return JacksonUtils.writeValueAsString((Object)this);
    }
}

