/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.dedicated_line;

import com.fizzgate.config.FizzMangerConfig;
import com.fizzgate.config.SystemConfig;
import com.fizzgate.dedicated_line.DedicatedLineService;
import com.fizzgate.dedicated_line.DedicatedLineUtils;
import com.fizzgate.proxy.FizzWebClient;
import com.fizzgate.util.DateTimeUtils;
import com.fizzgate.util.Result;
import com.fizzgate.util.WebUtils;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@ConditionalOnProperty(name={"fizz.dedicated-line.server.enable"}, havingValue="true")
@RestController
@RequestMapping(value={"//_fizz-dedicated-line"})
public class DedicatedLineController {
    private static final Logger log = LoggerFactory.getLogger(DedicatedLineController.class);
    @Resource
    private SystemConfig systemConfig;
    @Resource
    private DedicatedLineService dedicatedLineService;
    @Resource
    private FizzMangerConfig fizzMangerConfig;
    @Resource
    private FizzWebClient fizzWebClient;

    private Result<?> auth(ServerWebExchange exchange) {
        String dedicatedLineId = WebUtils.getDedicatedLineId(exchange);
        if (dedicatedLineId == null) {
            return Result.fail((String)"no dedicated line id in request");
        }
        String timestamp = WebUtils.getDedicatedLineTimestamp(exchange);
        if (timestamp == null) {
            return Result.fail((String)"no timestamp in request");
        }
        try {
            long ts = Long.parseLong(timestamp);
            LocalDateTime now = LocalDateTime.now();
            long timeliness = this.systemConfig.fizzDedicatedLineClientRequestTimeliness();
            long start = DateTimeUtils.toMillis((LocalDateTime)now.minusSeconds(timeliness));
            long end = DateTimeUtils.toMillis((LocalDateTime)now.plusSeconds(timeliness));
            if (start > ts || ts > end) {
                return Result.fail((String)"request timestamp invalid");
            }
        }
        catch (NumberFormatException e) {
            return Result.fail((String)"request timestamp format invalid");
        }
        String sign = WebUtils.getDedicatedLineSign(exchange);
        if (sign == null) {
            return Result.fail((String)"no sign in request");
        }
        String pairCodeSecretKey = this.dedicatedLineService.getSignSecretKey(dedicatedLineId);
        boolean equals = DedicatedLineUtils.checkSign(dedicatedLineId, timestamp, pairCodeSecretKey, sign);
        if (!equals) {
            String traceId = WebUtils.getTraceId(exchange);
            ThreadContext.put((String)"traceId", (String)traceId);
            log.warn("{} request authority: dedicated line id {}, timestamp {}, sign {} invalid", new Object[]{traceId, dedicatedLineId, timestamp, sign});
            return Result.fail((String)"request sign invalid");
        }
        return Result.succ();
    }

    @GetMapping(value={"/pair"})
    public Mono<Void> pair(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        String managerUrl = this.fizzMangerConfig.managerUrl;
        if (managerUrl == null) {
            return WebUtils.response(response, HttpStatus.INTERNAL_SERVER_ERROR, null, "no fizz manager url config");
        }
        String address = managerUrl + this.fizzMangerConfig.pairPath;
        String traceId = WebUtils.getTraceId(exchange);
        Mono<ClientResponse> remoteResponseMono = this.fizzWebClient.send(traceId, request.getMethod(), address, request.getHeaders(), null);
        return remoteResponseMono.flatMap(remoteResp -> {
            response.setStatusCode(remoteResp.statusCode());
            HttpHeaders respHeaders = response.getHeaders();
            HttpHeaders remoteRespHeaders = remoteResp.headers().asHttpHeaders();
            respHeaders.putAll((Map)remoteRespHeaders);
            if (log.isDebugEnabled()) {
                StringBuilder sb = com.fizzgate.util.ThreadContext.getStringBuilder();
                WebUtils.response2stringBuilder(traceId, remoteResp, sb);
                ThreadContext.put((String)"traceId", (String)traceId);
                log.debug(sb.toString());
            }
            return response.writeWith((Publisher)remoteResp.body(BodyExtractors.toDataBuffers())).doOnError(throwable -> this.cleanup((ClientResponse)remoteResp)).doOnCancel(() -> this.cleanup((ClientResponse)remoteResp));
        });
    }

    @GetMapping(value={"/doc/**"})
    public Mono<Void> doc(ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        Result<?> auth = this.auth(exchange);
        if (auth.code == 1) {
            String managerUrl = this.fizzMangerConfig.managerUrl;
            if (managerUrl == null) {
                return WebUtils.response(response, HttpStatus.INTERNAL_SERVER_ERROR, null, "no fizz manager url config");
            }
            ServerHttpRequest request = exchange.getRequest();
            String uri = request.getURI().toString();
            int dp = uri.indexOf("doc");
            String address = managerUrl + this.fizzMangerConfig.docPathPrefix + uri.substring(dp + 3);
            String traceId = WebUtils.getTraceId(exchange);
            Mono<ClientResponse> remoteResponseMono = this.fizzWebClient.send(traceId, request.getMethod(), address, request.getHeaders(), null);
            return remoteResponseMono.flatMap(remoteResp -> {
                response.setStatusCode(remoteResp.statusCode());
                HttpHeaders respHeaders = response.getHeaders();
                HttpHeaders remoteRespHeaders = remoteResp.headers().asHttpHeaders();
                respHeaders.putAll((Map)remoteRespHeaders);
                if (log.isDebugEnabled()) {
                    StringBuilder sb = com.fizzgate.util.ThreadContext.getStringBuilder();
                    WebUtils.response2stringBuilder(traceId, remoteResp, sb);
                    ThreadContext.put((String)"traceId", (String)traceId);
                    log.debug(sb.toString());
                }
                return response.writeWith((Publisher)remoteResp.body(BodyExtractors.toDataBuffers())).doOnError(throwable -> this.cleanup((ClientResponse)remoteResp)).doOnCancel(() -> this.cleanup((ClientResponse)remoteResp));
            });
        }
        return WebUtils.response(response, HttpStatus.FORBIDDEN, null, auth.msg);
    }

    private void cleanup(ClientResponse clientResponse) {
        if (clientResponse != null) {
            clientResponse.bodyToMono(Void.class).subscribe();
        }
    }
}

