/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.dedicated_line;

import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import com.fizzgate.config.SystemConfig;
import com.fizzgate.dedicated_line.DedicatedLineInfo;
import com.fizzgate.dedicated_line.DedicatedLineInfoService;
import com.fizzgate.dedicated_line.DedicatedLineUtils;
import com.fizzgate.proxy.FizzWebClient;
import com.fizzgate.util.NettyDataBufferUtils;
import com.fizzgate.util.SymmetricDecryptor;
import com.fizzgate.util.SymmetricEncryptor;
import com.fizzgate.util.ThreadContext;
import com.fizzgate.util.Utils;
import com.fizzgate.util.WebUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.adapter.DefaultServerWebExchange;
import org.springframework.web.server.adapter.ForwardedHeaderTransformer;
import org.springframework.web.server.i18n.LocaleContextResolver;
import org.springframework.web.server.session.WebSessionManager;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DedicatedLineHttpHandler
implements HttpHandler {
    private static final String disconnected_client_log_category = "DisconnectedClient";
    private static final Logger log = LoggerFactory.getLogger(DedicatedLineHttpHandler.class);
    private static final Logger lostClientLog = LoggerFactory.getLogger((String)"DisconnectedClient");
    private static final Set<String> disconnected_client_exceptions = new HashSet<String>(Arrays.asList("AbortedException", "ClientAbortException", "EOFException", "EofException"));
    private static final String symmetricEncryptor = "symmEncpT";
    private static final String symmetricDecryptor = "symmDecpT";
    private WebSessionManager sessionManager;
    private ServerCodecConfigurer serverCodecConfigurer;
    private LocaleContextResolver localeContextResolver;
    private ForwardedHeaderTransformer forwardedHeaderTransformer;
    private boolean enableLoggingRequestDetails = false;
    private SystemConfig systemConfig;
    private FizzWebClient fizzWebClient;
    private DedicatedLineInfoService dedicatedLineInfoService;

    public DedicatedLineHttpHandler(ReactiveWebServerApplicationContext applicationContext, WebSessionManager sessionManager, ServerCodecConfigurer codecConfigurer, LocaleContextResolver localeContextResolver, ForwardedHeaderTransformer forwardedHeaderTransformer) {
        this.sessionManager = sessionManager;
        this.serverCodecConfigurer = codecConfigurer;
        this.localeContextResolver = localeContextResolver;
        this.forwardedHeaderTransformer = forwardedHeaderTransformer;
        this.systemConfig = (SystemConfig)applicationContext.getBean(SystemConfig.class);
        this.fizzWebClient = (FizzWebClient)applicationContext.getBean(FizzWebClient.class);
        this.dedicatedLineInfoService = (DedicatedLineInfoService)applicationContext.getBean(DedicatedLineInfoService.class);
    }

    public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
        int secFS;
        if (this.forwardedHeaderTransformer != null) {
            try {
                request = this.forwardedHeaderTransformer.apply(request);
            }
            catch (Throwable t2) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to apply forwarded headers to {}", (Object)this.formatRequest(request), (Object)t2);
                }
                response.setStatusCode(HttpStatus.BAD_REQUEST);
                return response.setComplete();
            }
        }
        DefaultServerWebExchange exchange = new DefaultServerWebExchange(request, response, this.sessionManager, this.serverCodecConfigurer, this.localeContextResolver);
        String logPrefix = exchange.getLogPrefix();
        URI requestURI = request.getURI();
        String path = requestURI.getPath();
        String service = path.substring(1, secFS = path.indexOf(47, 1));
        DedicatedLineInfo dedicatedLineInfo = this.dedicatedLineInfoService.get(service);
        if (dedicatedLineInfo == null) {
            log.warn("{}{} service no dedicated line info", (Object)logPrefix, (Object)service);
            return WebUtils.response(response, HttpStatus.FORBIDDEN, null, logPrefix + ' ' + service + " service no dedicated line info");
        }
        String targetUrl = this.constructTargetUrl(requestURI, path, dedicatedLineInfo.url);
        HttpHeaders writableHttpHeaders = this.signAndSetHeaders(request.getHeaders(), dedicatedLineInfo.pairCodeId, dedicatedLineInfo.secretKey);
        int requestTimeout = this.systemConfig.fizzDedicatedLineClientRequestTimeout();
        int retryCount = this.systemConfig.fizzDedicatedLineClientRequestRetryCount();
        int retryInterval = this.systemConfig.fizzDedicatedLineClientRequestRetryInterval();
        try {
            Flux<DataBuffer> dataBufferFlux;
            Flux<DataBuffer> bodyFlux = dataBufferFlux = request.getBody();
            if (this.systemConfig.fizzDedicatedLineClientRequestCrypto() && request.getMethod() != HttpMethod.GET) {
                bodyFlux = this.encrypt(dataBufferFlux, dedicatedLineInfo.requestCryptoKey);
                writableHttpHeaders.remove((Object)"Content-Length");
            }
            Mono<ClientResponse> remoteResponseMono = this.fizzWebClient.send(request.getId(), request.getMethod(), targetUrl, writableHttpHeaders, bodyFlux, requestTimeout, retryCount, retryInterval);
            Mono respMono = remoteResponseMono.flatMap(remoteResp -> {
                String v;
                response.setStatusCode(remoteResp.statusCode());
                HttpHeaders respHeaders = response.getHeaders();
                HttpHeaders remoteRespHeaders = remoteResp.headers().asHttpHeaders();
                respHeaders.putAll((Map)remoteRespHeaders);
                if (log.isDebugEnabled()) {
                    StringBuilder sb = ThreadContext.getStringBuilder();
                    WebUtils.response2stringBuilder(logPrefix, remoteResp, sb);
                    log.debug(sb.toString());
                }
                Flux remoteRespBody = (Flux)remoteResp.body(BodyExtractors.toDataBuffers());
                if (this.systemConfig.fizzDedicatedLineClientRequestCrypto() && response.getStatusCode() == HttpStatus.OK && (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(v = respHeaders.getFirst("b-ecyt"))) || v.equals("1"))) {
                    respHeaders.remove((Object)"Content-Length");
                    return response.writeWith(this.decrypt((Flux<DataBuffer>)remoteRespBody, dedicatedLineInfo.requestCryptoKey));
                }
                return response.writeWith((Publisher)remoteRespBody).doOnError(throwable -> this.cleanup((ClientResponse)remoteResp)).doOnCancel(() -> this.cleanup((ClientResponse)remoteResp));
            });
            return respMono.doOnSuccess(v -> this.logResponse((ServerWebExchange)exchange)).onErrorResume(t -> this.handleUnresolvedError((ServerWebExchange)exchange, (Throwable)t));
        }
        catch (Throwable t3) {
            log.error(logPrefix + "500 Server Error for " + this.formatRequest(request), t3);
            return WebUtils.response(response, HttpStatus.INTERNAL_SERVER_ERROR, null, logPrefix + ' ' + Utils.getMessage((Throwable)t3));
        }
    }

    private Flux<DataBuffer> encrypt(Flux<DataBuffer> bodyFlux, String cryptoKey) {
        return NettyDataBufferUtils.join(bodyFlux).defaultIfEmpty((Object)NettyDataBufferUtils.EMPTY_DATA_BUFFER).flatMap(body -> {
            SymmetricEncryptor encryptor;
            if (body == NettyDataBufferUtils.EMPTY_DATA_BUFFER) {
                return Mono.empty();
            }
            byte[] bytes = null;
            if (body instanceof PooledDataBuffer) {
                try {
                    bytes = NettyDataBufferUtils.copyBytes((DataBuffer)body);
                }
                finally {
                    NettyDataBufferUtils.release((DataBuffer)body);
                }
            } else {
                bytes = body.asByteBuffer().array();
            }
            if ((encryptor = (SymmetricEncryptor)ThreadContext.get((String)symmetricEncryptor)) == null) {
                encryptor = new SymmetricEncryptor(SymmetricAlgorithm.AES, cryptoKey);
                ThreadContext.set((String)symmetricEncryptor, (Object)encryptor);
            } else if (!encryptor.secretKey.equals(cryptoKey)) {
                encryptor = new SymmetricEncryptor(SymmetricAlgorithm.AES, cryptoKey);
                ThreadContext.set((String)symmetricEncryptor, (Object)encryptor);
            }
            NettyDataBuffer from = NettyDataBufferUtils.from((byte[])encryptor.encrypt(bytes));
            return Mono.just((Object)from);
        }).flux();
    }

    private Flux<DataBuffer> decrypt(Flux<DataBuffer> bodyFlux, String cryptoKey) {
        return NettyDataBufferUtils.join(bodyFlux).defaultIfEmpty((Object)NettyDataBufferUtils.EMPTY_DATA_BUFFER).flatMap(body -> {
            SymmetricDecryptor decryptor;
            if (body == NettyDataBufferUtils.EMPTY_DATA_BUFFER) {
                return Mono.empty();
            }
            byte[] bytes = null;
            if (body instanceof PooledDataBuffer) {
                try {
                    bytes = NettyDataBufferUtils.copyBytes((DataBuffer)body);
                }
                finally {
                    NettyDataBufferUtils.release((DataBuffer)body);
                }
            } else {
                bytes = body.asByteBuffer().array();
            }
            if ((decryptor = (SymmetricDecryptor)ThreadContext.get((String)symmetricDecryptor)) == null) {
                decryptor = new SymmetricDecryptor(SymmetricAlgorithm.AES, cryptoKey);
                ThreadContext.set((String)symmetricDecryptor, (Object)decryptor);
            } else if (!decryptor.secretKey.equals(cryptoKey)) {
                decryptor = new SymmetricDecryptor(SymmetricAlgorithm.AES, cryptoKey);
                ThreadContext.set((String)symmetricDecryptor, (Object)decryptor);
            }
            NettyDataBuffer from = NettyDataBufferUtils.from((byte[])decryptor.decrypt(bytes));
            return Mono.just((Object)from);
        }).flux();
    }

    private String constructTargetUrl(URI requestURI, String path, String serverAddress) {
        StringBuilder b = ThreadContext.getStringBuilder();
        b.append(serverAddress).append(path);
        String qry = requestURI.getQuery();
        if (StringUtils.hasText((String)qry)) {
            if (org.apache.commons.lang3.StringUtils.indexOfAny((CharSequence)qry, (char[])new char[]{'{', '/', '#'}) > 0) {
                qry = requestURI.getRawQuery();
            }
            b.append('?').append(qry);
        }
        return b.toString();
    }

    private HttpHeaders signAndSetHeaders(HttpHeaders headers, String pairCodeId, String secretKey) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = DedicatedLineUtils.sign(pairCodeId, timestamp, secretKey);
        HttpHeaders writableHttpHeaders = HttpHeaders.writableHttpHeaders((HttpHeaders)headers);
        writableHttpHeaders.set("fizz-dl-id", pairCodeId);
        writableHttpHeaders.set("fizz-dl-ts", timestamp);
        writableHttpHeaders.set("fizz-dl-sign", sign);
        writableHttpHeaders.set("fizz-dl-client", this.systemConfig.fizzDedicatedLineClientId());
        return writableHttpHeaders;
    }

    private void cleanup(ClientResponse clientResponse) {
        if (clientResponse != null) {
            clientResponse.bodyToMono(Void.class).subscribe();
        }
    }

    private void logResponse(ServerWebExchange exchange) {
        WebUtils.traceDebug(log, traceOn -> {
            HttpStatus status = exchange.getResponse().getStatusCode();
            return exchange.getLogPrefix() + "Completed " + (status != null ? status : "200 OK") + (traceOn != false ? ", headers=" + this.formatHeaders(exchange.getResponse().getHeaders()) : "");
        });
    }

    private String formatHeaders(HttpHeaders responseHeaders) {
        return this.enableLoggingRequestDetails ? responseHeaders.toString() : (responseHeaders.isEmpty() ? "{}" : "{masked}");
    }

    private String formatRequest(ServerHttpRequest request) {
        String rawQuery = request.getURI().getRawQuery();
        String query = StringUtils.hasText((String)rawQuery) ? "?" + rawQuery : "";
        return "HTTP " + request.getMethod() + " \"" + request.getPath() + query + "\"";
    }

    private Mono<Void> handleUnresolvedError(ServerWebExchange exchange, Throwable t) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        String logPrefix = exchange.getLogPrefix();
        if (response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR)) {
            log.error(logPrefix + "500 Server Error for " + this.formatRequest(request), t);
            return WebUtils.response(response, null, null, logPrefix + ' ' + Utils.getMessage((Throwable)t));
        }
        if (this.isDisconnectedClientError(t)) {
            if (lostClientLog.isTraceEnabled()) {
                lostClientLog.trace(logPrefix + "Client went away", t);
            } else if (lostClientLog.isDebugEnabled()) {
                lostClientLog.debug(logPrefix + "Client went away: " + t + " (stacktrace at TRACE level for '" + disconnected_client_log_category + "')");
            }
            return WebUtils.response(response, null, null, logPrefix + ' ' + Utils.getMessage((Throwable)t));
        }
        log.error(logPrefix + "Error [" + t + "] for " + this.formatRequest(request) + ", but ServerHttpResponse already committed (" + response.getStatusCode() + ")");
        return Mono.error((Throwable)t);
    }

    private boolean isDisconnectedClientError(Throwable t) {
        String text;
        String message = NestedExceptionUtils.getMostSpecificCause((Throwable)t).getMessage();
        if (message != null && ((text = message.toLowerCase()).contains("broken pipe") || text.contains("connection reset by peer"))) {
            return true;
        }
        return disconnected_client_exceptions.contains(t.getClass().getSimpleName());
    }
}

