/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.dedicated_line;

import com.fizzgate.dedicated_line.DedicatedLineInfo;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.Result;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ConditionalOnProperty(name={"fizz.dedicated-line.client.enable"}, havingValue="true")
@Service
public class DedicatedLineInfoService {
    private static final Logger log = LoggerFactory.getLogger(DedicatedLineInfoService.class);
    private Map<String, DedicatedLineInfo> serviceDedicatedLineInfoMap = new HashMap<String, DedicatedLineInfo>(32);
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    @Value(value="${fizz.dedicated-line.client.enable:true}")
    private boolean fizzDedicatedLineClientEnable;

    @PostConstruct
    public void init() throws Throwable {
        if (this.fizzDedicatedLineClientEnable) {
            Result<?> result = this.initDedicatedLineInfo();
            if (result.code == 0) {
                throw new RuntimeException(result.msg, result.t);
            }
            result = this.lsnApiPairingInfoChange();
            if (result.code == 0) {
                throw new RuntimeException(result.msg, result.t);
            }
        }
    }

    private Result<?> initDedicatedLineInfo() {
        Result result = Result.succ();
        Flux resources = this.rt.opsForHash().entries((Object)"fizz_dedicated_line_info");
        resources.collectList().defaultIfEmpty(Collections.emptyList()).flatMap(es -> {
            if (!es.isEmpty()) {
                String json = null;
                try {
                    for (Map.Entry e : es) {
                        json = (String)e.getValue();
                        DedicatedLineInfo info = (DedicatedLineInfo)JacksonUtils.readValue((String)json, DedicatedLineInfo.class);
                        for (String service : info.services) {
                            this.serviceDedicatedLineInfoMap.put(service, info);
                        }
                        log.info("init dedicated line info: {}", (Object)info);
                    }
                }
                catch (Throwable t) {
                    result.code = 0;
                    result.msg = "init dedicated line info error, info: " + json;
                    result.t = t;
                }
            } else {
                log.info("no dedicated line info");
            }
            return Mono.empty();
        }).onErrorReturn(throwable -> {
            result.code = 0;
            result.msg = "init dedicated line info error";
            result.t = throwable;
            return true;
        }, (Object)result).block();
        return result;
    }

    private Result<?> lsnApiPairingInfoChange() {
        Result result = Result.succ();
        String channel = "fizz_dedicated_line_info_channel";
        this.rt.listenToChannel(new String[]{channel}).doOnError(t -> {
            result.code = 0;
            result.msg = "lsn error, channel: " + channel;
            result.t = t;
            log.error("lsn channel {} error", (Object)channel, t);
        }).doOnSubscribe(s -> log.info("success to lsn on {}", (Object)channel)).doOnNext(msg -> {
            String message = (String)msg.getMessage();
            try {
                DedicatedLineInfo info = (DedicatedLineInfo)JacksonUtils.readValue((String)message, DedicatedLineInfo.class);
                if (info.isDeleted) {
                    for (String service : info.services) {
                        this.serviceDedicatedLineInfoMap.remove(service);
                    }
                    log.info("remove dedicated line info: {}", (Object)info);
                } else {
                    for (String service : info.services) {
                        this.serviceDedicatedLineInfoMap.put(service, info);
                    }
                    log.info("update dedicated line info: {}", (Object)info);
                }
            }
            catch (Throwable t) {
                log.error("update dedicated line info error, {}", (Object)message, (Object)t);
            }
        }).subscribe();
        return result;
    }

    public DedicatedLineInfo get(String service) {
        return this.serviceDedicatedLineInfoMap.get(service);
    }
}

