/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.dedicated_line;

import com.fizzgate.dedicated_line.DedicatedLine;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.Result;
import com.fizzgate.util.UrlTransformUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ConditionalOnProperty(name={"fizz.dedicated-line.server.enable"}, havingValue="true")
@Service
public class DedicatedLineService {
    private static final Logger log = LoggerFactory.getLogger(DedicatedLineService.class);
    private Map<String, DedicatedLine> dedicatedLineMap = new HashMap<String, DedicatedLine>(32);
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    @Value(value="${fizz.dedicated-line.server.enable:true}")
    private boolean fizzDedicatedLineServerEnable;

    @PostConstruct
    public void init() throws Throwable {
        if (this.fizzDedicatedLineServerEnable) {
            Result<?> result = this.initDedicatedLine();
            if (result.code == 0) {
                throw new RuntimeException(result.msg, result.t);
            }
            result = this.lsnDedicatedLineChange();
            if (result.code == 0) {
                throw new RuntimeException(result.msg, result.t);
            }
        }
    }

    private Result<?> initDedicatedLine() {
        Result result = Result.succ();
        Flux resources = this.rt.opsForHash().entries((Object)"fizz_dedicated_line");
        resources.collectList().defaultIfEmpty(Collections.emptyList()).flatMap(es -> {
            if (!es.isEmpty()) {
                String json = null;
                try {
                    for (Map.Entry e : es) {
                        json = (String)e.getValue();
                        DedicatedLine dl = (DedicatedLine)JacksonUtils.readValue((String)json, DedicatedLine.class);
                        this.dedicatedLineMap.put(dl.pairCodeId, dl);
                    }
                }
                catch (Throwable t) {
                    result.code = 0;
                    result.msg = "init dedicated line error, json: " + json;
                    result.t = t;
                }
            } else {
                log.info("no dedicated line");
            }
            return Mono.empty();
        }).onErrorReturn(throwable -> {
            result.code = 0;
            result.msg = "init dedicated line error";
            result.t = throwable;
            return true;
        }, (Object)result).block();
        return result;
    }

    private Result<?> lsnDedicatedLineChange() {
        Result result = Result.succ();
        String channel = "fizz_dedicated_line_channel";
        this.rt.listenToChannel(new String[]{channel}).doOnError(t -> {
            result.code = 0;
            result.msg = "lsn error, channel: " + channel;
            result.t = t;
            log.error("lsn channel {} error", (Object)channel, t);
        }).doOnSubscribe(s -> log.info("success to lsn on {}", (Object)channel)).doOnNext(msg -> {
            String message = (String)msg.getMessage();
            try {
                DedicatedLine dl = (DedicatedLine)JacksonUtils.readValue((String)message, DedicatedLine.class);
                if (dl.isDeleted) {
                    this.dedicatedLineMap.remove(dl.pairCodeId);
                } else {
                    this.dedicatedLineMap.put(dl.pairCodeId, dl);
                }
            }
            catch (Throwable t) {
                log.error("update dedicated line error, {}", (Object)message, (Object)t);
            }
        }).subscribe();
        return result;
    }

    public boolean auth(String pairCodeId, HttpMethod method, String service, String path) {
        DedicatedLine dedicatedLine = this.dedicatedLineMap.get(pairCodeId);
        if (dedicatedLine == null) {
            return false;
        }
        if (dedicatedLine.servicesWithoutApiDocs.contains(service)) {
            return true;
        }
        Map<Object, Set<String>> methodPathsMap = dedicatedLine.apiDocMap.get(service);
        if (methodPathsMap == null) {
            return false;
        }
        Set<String> pathPatterns = methodPathsMap.get(method);
        if (pathPatterns != null && this.pathPatternMatch(path, pathPatterns)) {
            return true;
        }
        pathPatterns = methodPathsMap.get("AM");
        if (pathPatterns != null) {
            return this.pathPatternMatch(path, pathPatterns);
        }
        return false;
    }

    private boolean pathPatternMatch(String path, Set<String> pathPatterns) {
        if (pathPatterns.contains(path)) {
            return true;
        }
        for (String pathPattern : pathPatterns) {
            if (!UrlTransformUtils.ANT_PATH_MATCHER.match(pathPattern, path)) continue;
            return true;
        }
        return false;
    }

    public String getSignSecretKey(String pairCodeId) {
        DedicatedLine dedicatedLine = this.dedicatedLineMap.get(pairCodeId);
        if (dedicatedLine != null) {
            return dedicatedLine.secretKey;
        }
        return null;
    }

    public String getRequestCryptoKey(String pairCodeId) {
        DedicatedLine dedicatedLine = this.dedicatedLineMap.get(pairCodeId);
        if (dedicatedLine != null) {
            return dedicatedLine.requestCryptoKey;
        }
        return null;
    }

    public String getCustomConfig(String pairCodeId) {
        DedicatedLine dedicatedLine = this.dedicatedLineMap.get(pairCodeId);
        if (dedicatedLine != null) {
            return dedicatedLine.customConfig;
        }
        return null;
    }
}

