/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.dedicated_line;

import com.alibaba.cloud.nacos.discovery.NacosDiscoveryAutoConfiguration;
import com.fizzgate.dedicated_line.DedicatedLineWebServerInitializedEvent;
import com.fizzgate.service_registry.FizzServiceRegistration;
import com.fizzgate.service_registry.eureka.FizzEurekaHelper;
import com.fizzgate.service_registry.nacos.FizzNacosHelper;
import java.util.Properties;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Configuration
@ConditionalOnDiscoveryEnabled
@ConditionalOnProperty(name={"fizz.dedicated-line.client.enable"}, havingValue="true")
@AutoConfigureAfter(value={EurekaClientAutoConfiguration.class, NacosDiscoveryAutoConfiguration.class})
public class DedicatedLineServiceRegistration
implements ApplicationListener<DedicatedLineWebServerInitializedEvent> {
    private static final Logger log = LoggerFactory.getLogger(DedicatedLineServiceRegistration.class);
    private FizzServiceRegistration fizzServiceRegistration;
    @Value(value="${fizz.dedicated-line.client.enable:true}")
    private boolean fizzDedicatedLineClientEnable;

    public void onApplicationEvent(DedicatedLineWebServerInitializedEvent event) {
        if (!this.fizzDedicatedLineClientEnable) {
            return;
        }
        ReactiveWebServerApplicationContext applicationContext = event.getApplicationContext();
        ConfigurableEnvironment env = applicationContext.getEnvironment();
        String prefix = "fizz.dedicated-line.client.service-registration";
        boolean eureka = env.containsProperty(prefix + ".eureka.client.serviceUrl.defaultZone");
        boolean nacos = env.containsProperty(prefix + ".nacos.discovery.server-addr");
        if (eureka || nacos) {
            String[] propertyNames;
            MapPropertySource originTrackedMapPropertySource;
            boolean find;
            if (eureka) {
                Properties eurekaProperties = new Properties();
                find = false;
                for (PropertySource propertySource : env.getPropertySources()) {
                    if (!MapPropertySource.class.isAssignableFrom(propertySource.getClass())) continue;
                    originTrackedMapPropertySource = (MapPropertySource)propertySource;
                    for (String propertyName : propertyNames = originTrackedMapPropertySource.getPropertyNames()) {
                        int eurekaPos;
                        if (propertyName.length() <= 55 || (eurekaPos = propertyName.indexOf("eureka")) <= -1) continue;
                        eurekaProperties.setProperty(propertyName.substring(eurekaPos), originTrackedMapPropertySource.getProperty(propertyName).toString());
                        find = true;
                    }
                    if (!find) continue;
                    break;
                }
                if (!find) {
                    log.error("no eureka config");
                    return;
                }
                this.fizzServiceRegistration = FizzEurekaHelper.getServiceRegistration((ApplicationContext)applicationContext, eurekaProperties);
            }
            if (nacos) {
                Properties nacosProperties = new Properties();
                find = false;
                for (PropertySource propertySource : env.getPropertySources()) {
                    if (!MapPropertySource.class.isAssignableFrom(propertySource.getClass())) continue;
                    originTrackedMapPropertySource = (MapPropertySource)propertySource;
                    for (String propertyName : propertyNames = originTrackedMapPropertySource.getPropertyNames()) {
                        int naocsPos;
                        if (propertyName.length() <= 64 || (naocsPos = propertyName.indexOf("nacos")) <= -1) continue;
                        nacosProperties.setProperty(propertyName.substring(naocsPos), originTrackedMapPropertySource.getProperty(propertyName).toString());
                        find = true;
                    }
                    if (!find) continue;
                    break;
                }
                if (!find) {
                    log.error("no nacos config");
                    return;
                }
                this.fizzServiceRegistration = FizzNacosHelper.getServiceRegistration((ApplicationContext)applicationContext, nacosProperties);
            }
            this.fizzServiceRegistration.register();
        }
    }

    @PreDestroy
    public void stop() {
        if (this.fizzServiceRegistration != null) {
            this.fizzServiceRegistration.deregister();
        }
    }
}

