/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.dedicated_line;

import com.fizzgate.dedicated_line.DedicatedLineHttpHandler;
import com.fizzgate.dedicated_line.DedicatedLineWebServerInitializedEvent;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.reactive.HttpHandlerAutoConfiguration;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import org.springframework.web.server.session.DefaultWebSessionManager;
import org.springframework.web.server.session.WebSessionManager;

@ConditionalOnProperty(name={"fizz.dedicated-line.client.enable"}, havingValue="true")
@Configuration
@AutoConfigureAfter(value={HttpHandlerAutoConfiguration.class})
public class DedicatedLineWebServer {
    private static final Logger log = LoggerFactory.getLogger(DedicatedLineWebServer.class);
    @Resource
    private ReactiveWebServerApplicationContext applicationContext;
    @Resource
    private HttpHandler httpHandler;
    private WebServer server;
    @Value(value="${fizz.dedicated-line.client.port:8601}")
    private int port = 8601;
    @Value(value="${fizz.dedicated-line.client.enable:true}")
    private boolean fizzDedicatedLineClientEnable;

    @PostConstruct
    public void start() {
        if (this.fizzDedicatedLineClientEnable) {
            HttpWebHandlerAdapter adapter = (HttpWebHandlerAdapter)this.httpHandler;
            NettyReactiveWebServerFactory factory = new NettyReactiveWebServerFactory(this.port);
            this.server = factory.getWebServer((HttpHandler)new DedicatedLineHttpHandler(this.applicationContext, (WebSessionManager)new DefaultWebSessionManager(), adapter.getCodecConfigurer(), adapter.getLocaleContextResolver(), adapter.getForwardedHeaderTransformer()));
            this.server.start();
            log.info("fizz dedicated line web server listen on {}", (Object)this.port);
            this.applicationContext.publishEvent((ApplicationEvent)new DedicatedLineWebServerInitializedEvent(this.server, this.applicationContext));
        }
    }

    @PreDestroy
    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

